/*
 * Decompiled with CFR 0.152.
 */
package billschitt.throwableRopeCoilMod.mixin;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockRope;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockRope.class}, remap=false)
public class BlockRopeMixin
extends Block {
    public BlockRopeMixin(String key, int id, Material material) {
        super(key, id, material);
    }

    public void onBlockDestroyedByPlayer(World world, int x, int y, int z, Side side, int meta, EntityPlayer player, Item item) {
        if (player != null && player.isSneaking()) {
            this.removeConnectedRope(world, x, y, z, player);
            System.out.println("Attempting to remove rope");
        } else {
            super.onBlockDestroyedByPlayer(world, x, y, z, side, meta, player, item);
        }
    }

    @Inject(method={"getBreakResult"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity, CallbackInfoReturnable<ItemStack[]> cir) {
        EntityPlayer player;
        if (dropCause == EnumDropCause.PROPER_TOOL && (player = world.getClosestPlayer((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 5.0)) != null && player.isSneaking()) {
            cir.setReturnValue((Object)new ItemStack[0]);
        }
    }

    private void removeConnectedRope(World world, int x, int y, int z, EntityPlayer player) {
        if (player.gamemode != Gamemode.creative) {
            this.addRopeToInventoryOrDrop(player, world, x, y, z);
        }
        while (world.getBlockId(x, y - 1, z) == Block.rope.id) {
            world.setBlockWithNotify(x, --y, z, 0);
            if (player.gamemode != Gamemode.creative) {
                this.addRopeToInventoryOrDrop(player, world, x, y, z);
            }
            System.out.println("Removed rope");
        }
    }

    private void addRopeToInventoryOrDrop(EntityPlayer player, World world, int x, int y, int z) {
        ItemStack ropeItem = new ItemStack(Item.rope);
        player.inventory.insertItem(ropeItem, true);
        if (ropeItem.stackSize > 0) {
            world.dropItem(x, y, z, ropeItem);
        }
    }
}

