/*
 * Decompiled with CFR 0.152.
 */
package billschitt.throwableRopeCoilMod.entity;

import net.minecraft.core.HitResult;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockRope;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.projectile.EntityProjectile;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class EntityThrowableRopeCoil
extends EntityProjectile {
    private static final int MAX_ROPE_LENGTH = 4;

    public EntityThrowableRopeCoil(World world) {
        super(world);
        this.modelItem = Item.ammoSnowball;
    }

    public EntityThrowableRopeCoil(World world, EntityLiving owner) {
        super(world, owner);
        this.modelItem = Item.ammoSnowball;
    }

    public void onHit(HitResult hitResult) {
        if (!this.world.isClientSide && hitResult.hitType == HitResult.HitType.TILE) {
            int y;
            int x = hitResult.x;
            int z = hitResult.z;
            Side side = hitResult.side;
            int ropeCoilsToDrop = 0;
            int ropesToPlace = 4;
            if (this.world.getBlockId(x, y, z) == Block.rope.id) {
                for (y = hitResult.y; y > 0 && this.world.getBlockId(x, y - 1, z) == Block.rope.id; --y) {
                }
                --y;
            } else {
                switch (side) {
                    case NORTH: {
                        --z;
                        break;
                    }
                    case SOUTH: {
                        ++z;
                        break;
                    }
                    case WEST: {
                        --x;
                        break;
                    }
                    case EAST: {
                        ++x;
                        break;
                    }
                    case TOP: {
                        ropeCoilsToDrop = 4;
                        ropesToPlace = 0;
                        break;
                    }
                    case BOTTOM: {
                        --y;
                        break;
                    }
                }
            }
            while (ropesToPlace > 0 && y > 0) {
                if (this.world.getBlockId(x, y, z) == 0) {
                    this.world.setBlock(x, y, z, Block.rope.id);
                    this.updateRopeConnections(x, y, z);
                    --ropesToPlace;
                    --y;
                    continue;
                }
                if (this.world.getBlockId(x, y, z) == Block.rope.id) {
                    --y;
                    continue;
                }
                ropeCoilsToDrop = ropesToPlace;
                break;
            }
            this.world.markBlocksDirty(x - 1, y, z - 1, x + 1, y + 4, z + 1);
            if (ropeCoilsToDrop > 0) {
                this.dropRopeCoils(x, y + 1, z, ropeCoilsToDrop);
            }
        }
        this.remove();
    }

    private void dropRopeCoils(int x, int y, int z, int count) {
        for (int i = 0; i < count; ++i) {
            ItemStack itemStack = new ItemStack(Item.rope, 1);
            EntityItem entityItem = new EntityItem(this.world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, itemStack);
            entityItem.xd = 0.0;
            entityItem.yd = 0.05;
            entityItem.zd = 0.0;
            entityItem.yd = 0.25;
            this.world.entityJoinedWorld((Entity)entityItem);
        }
    }

    private void updateRopeConnections(int x, int y, int z) {
        this.updateSingleRopeBlock(x, y, z);
        this.updateSingleRopeBlock(x + 1, y, z);
        this.updateSingleRopeBlock(x - 1, y, z);
        this.updateSingleRopeBlock(x, y, z + 1);
        this.updateSingleRopeBlock(x, y, z - 1);
        this.updateSingleRopeBlock(x, y + 1, z);
        this.updateSingleRopeBlock(x, y - 1, z);
    }

    private void updateSingleRopeBlock(int x, int y, int z) {
        if (this.world.getBlockId(x, y, z) == Block.rope.id) {
            BlockRope ropeBlock = (BlockRope)Block.rope;
            ropeBlock.setBlockBoundsBasedOnState((WorldSource)this.world, x, y, z);
            this.world.notifyBlockChange(x, y, z, Block.rope.id);
            this.world.notifyBlocksOfNeighborChange(x, y, z, Block.rope.id);
        }
    }
}

