/*
 * Decompiled with CFR 0.152.
 */
package midou.legacyfix.mixin;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import midou.legacyfix.mixin.ThreadLoginVerifierAccessor;
import midou.legacyfix.utils.ApiServers;
import net.minecraft.core.net.packet.Packet1Login;
import net.minecraft.server.net.handler.NetLoginHandler;
import net.minecraft.server.net.thread.ThreadLoginVerifier;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ThreadLoginVerifier.class})
public class ThreadLoginVerifierMixin {
    @Inject(method={"run"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void onRun(CallbackInfo ci) {
        ThreadLoginVerifierAccessor accessor = (ThreadLoginVerifierAccessor)((Object)this);
        try {
            Packet1Login loginPacket = accessor.getLoginPacket();
            NetLoginHandler loginHandler = accessor.getLoginHandler();
            String serverId = NetLoginHandler.getServerId((NetLoginHandler)loginHandler);
            String username = URLEncoder.encode(loginPacket.username, "UTF-8");
            String urlStr = ApiServers.getSessionURL() + "/session/minecraft/hasJoined?username=" + username + "&serverId=" + URLEncoder.encode(serverId, "UTF-8");
            if (ThreadLoginVerifierMixin.hasJoined(username, serverId, null)) {
                NetLoginHandler.setLoginPacket((NetLoginHandler)loginHandler, (Packet1Login)loginPacket);
            } else {
                loginHandler.kickUser("Failed to verify username!");
            }
            ci.cancel();
        }
        catch (Exception e) {
            e.printStackTrace();
            accessor.getLoginHandler().kickUser("Failed to verify username! [internal error " + e + "]");
            ci.cancel();
        }
    }

    private static boolean hasJoined(String username, String serverId, String ip) throws IOException {
        URL url = new URL(ApiServers.getSessionURL() + "/session/minecraft/hasJoined?username=" + username + "&serverId=" + serverId + (ip != null ? "&ip=" + ip : ""));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setDoInput(true);
        connection.setDoOutput(false);
        connection.connect();
        int responseCode = connection.getResponseCode();
        connection.disconnect();
        return responseCode == 200;
    }
}

