/*
 * Decompiled with CFR 0.152.
 */
package midou.legacyfix.mixin;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import midou.legacyfix.mixin.NetClientHandlerAccessor;
import midou.legacyfix.utils.ApiServers;
import net.minecraft.client.net.handler.NetClientHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.Packet1Login;
import net.minecraft.core.net.packet.Packet2Handshake;
import net.minecraft.core.util.helper.RSA;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NetClientHandler.class})
public class NetClientHandlerMixin {
    @Inject(method={"handleHandshake"}, at={@At(value="INVOKE", target="Ljava/net/URL;<init>(Ljava/lang/String;)V")}, cancellable=true, remap=false)
    private void onHandleHandshake(Packet2Handshake packet2handshake, CallbackInfo ci) {
        NetClientHandlerAccessor accessor = (NetClientHandlerAccessor)((Object)this);
        if (accessor.getMinecraft() == null || accessor.getMinecraft().session == null) {
            throw new IllegalStateException("Minecraft or session is not set");
        }
        if (!packet2handshake.username.equals("-")) {
            try {
                String user = accessor.getMinecraft().session.username;
                String sessionId = accessor.getMinecraft().session.sessionId;
                String serverId = packet2handshake.username;
                if (user == null || sessionId == null || serverId == null) {
                    accessor.getNetworkManager().networkShutdown("disconnect.loginFailedInfo", new Object[]{"Missing parameters"});
                    throw new IllegalArgumentException("Missing parameters");
                }
                String accessToken = sessionId.split(":")[1];
                String uuid = this.getUuid(user);
                if (uuid == null) {
                    accessor.getNetworkManager().networkShutdown("disconnect.loginFailedInfo", new Object[]{"Couldn't find UUID of " + user});
                    ci.cancel();
                    return;
                }
                URL authUrl = new URL(ApiServers.getSessionURL() + "/session/minecraft/join");
                HttpURLConnection connection = (HttpURLConnection)authUrl.openConnection();
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setRequestProperty("Accept", "application/json");
                String payload = "{\"accessToken\": \"" + accessToken + "\",\"selectedProfile\": \"" + uuid + "\",\"serverId\": \"" + serverId + "\"}";
                try (OutputStream os = connection.getOutputStream();){
                    os.write(payload.getBytes(StandardCharsets.UTF_8));
                }
                int responseCode = connection.getResponseCode();
                if (responseCode == 204) {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    bufferedReader.close();
                    RSA.RSAKeyChain = RSA.generateKeyPair();
                    accessor.getNetworkManager().addToSendQueue((Packet)new Packet1Login(accessor.getMinecraft().session.username, 29184, RSA.getPublicKey((PublicKey)RSA.RSAKeyChain.getPublic())));
                } else {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
                    String errorResponse = bufferedReader.readLine();
                    bufferedReader.close();
                    accessor.getNetworkManager().networkShutdown("disconnect.loginFailedInfo", new Object[]{errorResponse});
                }
                connection.disconnect();
                ci.cancel();
            }
            catch (Exception e) {
                e.printStackTrace();
                accessor.getNetworkManager().networkShutdown("disconnect.genericReason", new Object[]{"Internal client error: " + e.toString()});
                ci.cancel();
            }
        }
    }

    private String getUuid(String username) throws IOException {
        String string;
        block8: {
            String accountUrl = ApiServers.getAccountURL();
            InputStream in = new URL(accountUrl + "/users/profiles/minecraft/" + username).openStream();
            try {
                JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(in)).getAsJsonObject();
                string = json.get("id").getAsString();
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return null;
                }
            }
            in.close();
        }
        return string;
    }
}

