/*
 * Decompiled with CFR 0.152.
 */
package bigjango.babies.mixin;

import bigjango.babies.mixin.EntityAnimalMixin;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.animal.EntityWolf;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.ItemFood;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityWolf.class}, remap=false)
public abstract class EntityWolfMixin
extends EntityAnimalMixin {
    public EntityWolfMixin(World world) {
        super(world);
    }

    @Shadow
    public abstract String getWolfOwner();

    @Override
    public boolean babies$canFeed(EntityPlayer player, ItemStack is) {
        return player.username.equalsIgnoreCase(this.getWolfOwner()) && is != null && is.getItem() instanceof ItemFood && ((ItemFood)is.getItem()).getIsWolfsFavoriteMeat() && this.getHealth() >= this.getMaxHealth();
    }

    @Override
    public Entity babies$giveBirth(Entity father) {
        Entity baby = super.babies$giveBirth(father);
        if (baby == null) {
            return baby;
        }
        EntityWolf f = (EntityWolf)father;
        ((EntityWolf)baby).setWolfOwner(((EntityWolf)father).getWolfOwner());
        if (this.random.nextInt(2) == 0) {
            ((EntityWolf)baby).setWolfOwner(this.getWolfOwner());
        }
        ((EntityWolf)baby).setWolfTamed(true);
        return baby;
    }

    @Inject(method={"findPlayerToAttack"}, at={@At(value="HEAD")}, cancellable=true)
    protected void __findPlayerToAttack(CallbackInfoReturnable<Entity> cir) {
        Entity pta;
        if (this.babies$breedable() && this.babies$getLoveTimer() > 0 && (pta = this.real_findPlayerToAttack()) != null && !this.isMovementCeased()) {
            cir.setReturnValue((Object)pta);
        }
    }

    @Inject(method={"attackEntity"}, at={@At(value="HEAD")}, cancellable=true)
    void __attackEntity(Entity entity, float distance, CallbackInfo ci) {
        if (this.real_attackEntity(entity, distance)) {
            ci.cancel();
        }
    }
}

