/*
 * Decompiled with CFR 0.152.
 */
package bigjango.babies.mixin;

import bigjango.babies.IAgableMob;
import com.mojang.nbt.CompoundTag;
import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.EntityPathfinder;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pathfinder.Path;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityPathfinder.class}, remap=false)
public abstract class EntityPathfinderMixin
extends EntityLiving {
    @Unique
    boolean passiveTarget = false;
    @Shadow
    protected Entity entityToAttack;
    @Shadow
    protected Path pathToEntity;

    public EntityPathfinderMixin(World world) {
        super(world);
    }

    @Unique
    private void spawnHearts() {
        double xa = this.random.nextGaussian() * 0.02;
        double ya = this.random.nextGaussian() * 0.02;
        double za = this.random.nextGaussian() * 0.02;
        this.world.spawnParticle("heart", this.x + (double)(this.random.nextFloat() * this.bbWidth * 2.0f) - (double)this.bbWidth, this.y + 0.5 + (double)(this.random.nextFloat() * this.bbHeight), this.z + (double)(this.random.nextFloat() * this.bbWidth * 2.0f) - (double)this.bbWidth, xa, ya, za, 0);
    }

    @Shadow
    protected abstract Entity findPlayerToAttack();

    @Inject(method={"updatePlayerActionState"}, at={@At(value="HEAD")})
    protected void _updatePlayerActionState(CallbackInfo ci) {
        if (this.passiveTarget && this.entityToAttack != null) {
            this.pathToEntity = this.world.getPathToEntity((Entity)this, this.entityToAttack, 20.0f);
        }
    }

    public void onLivingUpdate() {
        if (this instanceof IAgableMob) {
            IAgableMob e = (IAgableMob)((Object)this);
            if (this.entityToAttack instanceof EntityPlayer && this.passiveTarget && !e.babies$canFeed((EntityPlayer)this.entityToAttack, ((EntityPlayer)this.entityToAttack).getHeldItem())) {
                this.entityToAttack = null;
                this.passiveTarget = false;
            }
            if (e.babies$agable()) {
                int age = e.babies$getAge();
                if (age < 0 && e.babies$agable()) {
                    e.babies$setAge(age + 1);
                    e.babies$setLoveTimer(0);
                } else if (age > 0) {
                    e.babies$setAge(age - 1);
                    e.babies$setLoveTimer(0);
                }
            }
            if (e.babies$breedable()) {
                int inLove = e.babies$getLoveTimer();
                if (inLove > 0) {
                    if (--inLove % 10 == 0) {
                        this.spawnHearts();
                    }
                } else {
                    inLove = 0;
                }
                e.babies$setLoveTimer(inLove);
            }
            if (this.entityToAttack == null && (e.babies$breedable() && e.babies$getLoveTimer() > 0 || e.babies$dependsOnParent())) {
                this.entityToAttack = this.findPlayerToAttack();
            }
        }
        super.onLivingUpdate();
    }

    @Unique
    public Entity real_findPlayerToAttack() {
        block4: {
            IAgableMob p;
            List entites;
            IAgableMob e;
            block5: {
                this.passiveTarget = false;
                if (!(this instanceof IAgableMob)) break block4;
                e = (IAgableMob)((Object)this);
                float r = 8.0f;
                entites = this.world.getEntitiesWithinAABBExcludingEntity((Entity)this, this.bb.expand((double)r, (double)r, (double)r));
                if (e.babies$breedable() && e.babies$getLoveTimer() > 0) {
                    for (Entity partner : entites) {
                        if (!(partner instanceof IAgableMob) || !(p = (IAgableMob)partner).babies$canBreedWith((Entity)this) || !p.babies$breedable() || p.babies$getLoveTimer() <= 0) continue;
                        this.passiveTarget = true;
                        return partner;
                    }
                }
                if (e.babies$getAge() != 0) break block5;
                for (Entity p2 : entites) {
                    if (!(p2 instanceof EntityPlayer) || !e.babies$canFeed((EntityPlayer)p2, ((EntityPlayer)p2).getHeldItem())) continue;
                    this.passiveTarget = true;
                    return p2;
                }
                break block4;
            }
            if (!e.babies$dependsOnParent()) break block4;
            for (Entity parent : entites) {
                if (!(parent instanceof IAgableMob) || !(p = (IAgableMob)parent).babies$canBreedWith((Entity)this) || p.babies$getAge() < 0) continue;
                this.passiveTarget = true;
                return parent;
            }
        }
        return null;
    }

    @Shadow
    protected abstract boolean isMovementCeased();

    @Inject(method={"findPlayerToAttack"}, at={@At(value="HEAD")}, cancellable=true)
    public void _findPlayerToAttack(CallbackInfoReturnable<Entity> cir) {
        Entity pta = this.real_findPlayerToAttack();
        if (pta != null && !this.isMovementCeased()) {
            cir.setReturnValue((Object)pta);
        }
    }

    @Unique
    public boolean real_attackEntity(Entity entity, float distance) {
        if (this.world.isClientSide) {
            return false;
        }
        if (distance < 2.0f && entity.bb.maxY > this.bb.minY && entity.bb.minY < this.bb.maxY && this instanceof IAgableMob && entity instanceof IAgableMob && entity == this.entityToAttack && this.passiveTarget) {
            IAgableMob e = (IAgableMob)((Object)this);
            if (e.babies$breedable() && e.babies$getLoveTimer() > 0 && e.babies$canBreedWith(entity) && ((IAgableMob)entity).babies$getLoveTimer() > 0) {
                Entity baby = e.babies$giveBirth(entity);
                if (baby != null) {
                    ((IAgableMob)baby).babies$setAge(-24000);
                    baby.moveTo(this.x, this.y, this.z, this.yRot, this.xRot);
                    for (int i = 0; i < 7; ++i) {
                        this.spawnHearts();
                    }
                    this.world.entityJoinedWorld(baby);
                }
                e.babies$setAge(6000);
                e.babies$setLoveTimer(0);
                this.entityToAttack = null;
                ((IAgableMob)entity).babies$setAge(6000);
                ((IAgableMob)entity).babies$setLoveTimer(0);
                ((EntityPathfinder)entity).setTarget(null);
                return true;
            }
        } else if (this.passiveTarget) {
            return true;
        }
        return false;
    }

    @Inject(method={"attackEntity"}, at={@At(value="HEAD")}, cancellable=true)
    void _attackEntity(Entity entity, float distance, CallbackInfo ci) {
        if (this.real_attackEntity(entity, distance)) {
            ci.cancel();
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this instanceof IAgableMob && ((IAgableMob)((Object)this)).babies$agable()) {
            tag.putShort("Age_J", (short)((IAgableMob)((Object)this)).babies$getAge());
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (this instanceof IAgableMob && ((IAgableMob)((Object)this)).babies$agable()) {
            if (!tag.containsKey("Age_J")) {
                ((IAgableMob)((Object)this)).babies$setAge(0);
            } else {
                ((IAgableMob)((Object)this)).babies$setAge(tag.getShort("Age_J"));
            }
        }
    }

    public boolean interact(EntityPlayer player) {
        ItemStack is = player.inventory.getCurrentItem();
        if (is != null && this instanceof IAgableMob && ((IAgableMob)((Object)this)).babies$canFeed(player, is)) {
            IAgableMob e = (IAgableMob)((Object)this);
            if (e.babies$isBaby()) {
                e.babies$setAge(Math.min(0, e.babies$getAge() + 600));
                e.babies$feed(player, is);
                this.spawnHearts();
            } else if (e.babies$breedable()) {
                e.babies$setLoveTimer(600);
                for (int i = 0; i < 7; ++i) {
                    this.spawnHearts();
                }
                this.entityToAttack = null;
                e.babies$feed(player, is);
            }
            return true;
        }
        return super.interact(player);
    }

    public void handleEntityEvent(byte event, float a) {
        if (event == 47 && this instanceof IAgableMob) {
            ((IAgableMob)((Object)this)).babies$setAge((int)a);
        } else {
            super.handleEntityEvent(event, a);
        }
    }
}

