/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.fabricmc.loader.api.FabricLoader;
import turniplabs.halplibe.HalpLibe;
import turniplabs.halplibe.util.ConfigUpdater;
import turniplabs.halplibe.util.toml.Toml;
import turniplabs.halplibe.util.toml.TomlParser;

public class TomlConfigHandler {
    private static final String CONFIG_DIRECTORY = FabricLoader.getInstance().getGameDir().toString() + "/config/";
    private Toml defaults;
    private Toml config;
    private Toml rawParsed;
    private final String configFileName;
    private final File configFile;
    private ConfigUpdater updater;

    public TomlConfigHandler(String modID, Toml defaults) {
        this.configFileName = modID + ".cfg";
        this.configFile = new File(this.getFilePath());
        this.defaults = defaults;
        this.config = defaults.getComment().isPresent() ? new Toml(defaults.getComment().get()) : new Toml();
        this.config.addMissing(defaults);
        this.create();
    }

    public TomlConfigHandler(String modID, Toml defaults, boolean create) {
        this.configFileName = modID + ".cfg";
        this.configFile = new File(this.getFilePath());
        this.defaults = defaults;
        this.config = defaults.getComment().isPresent() ? new Toml(defaults.getComment().get()) : new Toml();
        this.config.addMissing(defaults);
        if (create) {
            this.create();
        }
    }

    public TomlConfigHandler(ConfigUpdater updater, String modID, Toml defaults) {
        this(modID, defaults);
        this.updater = updater;
    }

    public void create() {
        File configFile = new File(this.getFilePath());
        HalpLibe.LOGGER.info("Config file name: " + this.configFileName);
        HalpLibe.LOGGER.info("Config file path: " + configFile.getAbsolutePath());
        try {
            if (!configFile.exists()) {
                HalpLibe.LOGGER.info("Config file does not exist. Creating...");
                configFile.getParentFile().mkdirs();
                configFile.createNewFile();
                this.writeConfig();
            } else {
                this.loadConfig();
                this.writeConfig();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setDefaults(Toml defaults) {
        this.defaults = defaults;
        this.config.addMissing(defaults);
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public String getFilePath() {
        return CONFIG_DIRECTORY + this.configFileName;
    }

    public String getString(String key) {
        Object o = this.config.get(key);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public int getInt(String key) {
        return this.config.get(key, Integer.class);
    }

    public long getLong(String key) {
        return this.config.get(key, Long.class);
    }

    public float getFloat(String key) {
        return this.config.get(key, Float.class).floatValue();
    }

    public double getDouble(String key) {
        return this.config.get(key, Double.class);
    }

    public boolean getBoolean(String key) {
        return this.config.get(key, Boolean.class);
    }

    public void writeConfig() {
        File configFile = new File(this.getFilePath());
        this.config.merge(this.defaults);
        if (this.rawParsed != null) {
            this.rawParsed.merge(true, this.config);
        } else {
            this.rawParsed = this.config;
        }
        try (FileOutputStream output = new FileOutputStream(configFile);){
            ((OutputStream)output).write(this.rawParsed.toString().getBytes());
            ((OutputStream)output).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadConfig() {
        File configFile = new File(this.getFilePath());
        this.config.merge(this.defaults);
        this.loadConfig(configFile, this.config);
    }

    private void loadConfig(File configFile, Toml properties) {
        try (FileInputStream input = new FileInputStream(configFile);){
            byte[] buf;
            int count;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((count = ((InputStream)input).read(buf = new byte[Math.max(2048, ((InputStream)input).available())])) != -1) {
                baos.write(buf, 0, count);
            }
            Toml parsed = TomlParser.parse(baos.toString());
            if (this.defaults.getComment().isPresent()) {
                this.rawParsed = new Toml(this.defaults.getComment().get());
                this.rawParsed.addMissing(parsed);
            } else {
                this.rawParsed = parsed;
            }
            if (this.updater != null) {
                this.updater.updating = this.rawParsed;
                this.updater.update();
            }
            properties.merge(true, this.rawParsed);
            ((InputStream)input).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Toml getRawParsed() {
        return this.rawParsed;
    }
}

