/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.mixin.mixins;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.lang.Language;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import turniplabs.halplibe.HalpLibe;
import turniplabs.halplibe.mixin.accessors.LanguageAccessor;
import turniplabs.halplibe.util.DirectoryManager;

@Mixin(value={I18n.class}, remap=false)
public abstract class I18nMixin {
    @Shadow
    private Language currentLanguage;

    @Unique
    private static String[] filesInDir(String directory) {
        ArrayList<String> paths = new ArrayList<String>();
        if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        try {
            Path myPath;
            URI uri = Objects.requireNonNull(I18n.class.getResource(directory)).toURI();
            FileSystem fileSystem = null;
            if (uri.getScheme().equals("jar")) {
                try {
                    fileSystem = FileSystems.getFileSystem(uri);
                }
                catch (Exception var9) {
                    fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                }
                myPath = fileSystem.getPath(directory, new String[0]);
            } else {
                myPath = Paths.get(uri);
            }
            Stream<Path> walk = Files.walk(myPath, 1, new FileVisitOption[0]);
            try {
                Iterator it = walk.iterator();
                it.next();
                while (it.hasNext()) {
                    paths.add(directory + ((Path)it.next()).getFileName().toString());
                }
            }
            catch (Throwable var10) {
                if (walk != null) {
                    try {
                        walk.close();
                    }
                    catch (Throwable var8) {
                        var10.addSuppressed(var8);
                    }
                }
                throw var10;
            }
            walk.close();
            if (fileSystem != null) {
                fileSystem.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return paths.toArray(new String[0]);
    }

    @Shadow
    public static InputStream getResourceAsStream(String path) {
        return null;
    }

    @Inject(method={"reload(Ljava/lang/String;Z)V"}, at={@At(value="TAIL")})
    public void addHalplibeModLangFiles(String languageCode, boolean save, CallbackInfo ci) {
        Properties entries = ((LanguageAccessor)this.currentLanguage).getEntries();
        Language.Default defaultLanguage = Language.Default.INSTANCE;
        Properties defaultEntries = ((LanguageAccessor)defaultLanguage).getEntries();
        String defaultLangId = defaultLanguage.getId();
        String currentLangId = this.currentLanguage.getId();
        HalpLibe.LOGGER.debug("Current lang: " + currentLangId);
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            InputStreamReader r;
            InputStream stream;
            String path = DirectoryManager.getLanguageDirectory(mod.getMetadata().getId());
            Object[] rootLangs = I18nMixin.filesInDir(path);
            Object[] subCurrentLangs = I18nMixin.filesInDir(path + currentLangId + "/");
            Object[] subDefaultLangs = I18nMixin.filesInDir(path + defaultLangId + "/");
            HalpLibe.LOGGER.debug(mod.getMetadata().getId() + " contains " + rootLangs.length + subDefaultLangs.length + subCurrentLangs.length + " language files.");
            HalpLibe.LOGGER.debug(Arrays.toString(rootLangs));
            HalpLibe.LOGGER.debug(Arrays.toString(subCurrentLangs));
            HalpLibe.LOGGER.debug(Arrays.toString(subDefaultLangs));
            for (Object lang : rootLangs) {
                if (((String)lang).contains(currentLangId)) {
                    try {
                        stream = I18nMixin.getResourceAsStream((String)lang);
                        try {
                            if (stream != null) {
                                r = new InputStreamReader(stream, StandardCharsets.UTF_8);
                                entries.load(r);
                            }
                        }
                        finally {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (!((String)lang).contains(defaultLangId)) continue;
                try {
                    stream = I18nMixin.getResourceAsStream((String)lang);
                    try {
                        if (stream == null) continue;
                        r = new InputStreamReader(stream, StandardCharsets.UTF_8);
                        defaultEntries.load(r);
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            for (Object lang : subCurrentLangs) {
                try {
                    stream = I18nMixin.getResourceAsStream((String)lang);
                    try {
                        if (stream == null) continue;
                        r = new InputStreamReader(stream, StandardCharsets.UTF_8);
                        entries.load(r);
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            for (Object lang : subDefaultLangs) {
                try {
                    stream = I18nMixin.getResourceAsStream((String)lang);
                    try {
                        if (stream == null) continue;
                        r = new InputStreamReader(stream, StandardCharsets.UTF_8);
                        entries.load(r);
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

