/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.helper.gui.packet;

import com.mojang.nbt.CompoundTag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import turniplabs.halplibe.helper.gui.packet.PacketOpenGui;
import turniplabs.halplibe.helper.gui.registered.RegisteredGui;

public class PacketOpenItemGui
extends PacketOpenGui {
    public ItemStack itemStack;

    public PacketOpenItemGui(@NotNull RegisteredGui gui, int windowId, @NotNull ItemStack itemStack) {
        super(gui, windowId);
        this.itemStack = itemStack;
    }

    public PacketOpenItemGui() {
    }

    @Override
    public void readPacketData(DataInputStream input) throws IOException {
        super.readPacketData(input);
        this.itemStack = ItemStack.readItemStackFromNbt((CompoundTag)PacketOpenItemGui.readCompressedCompoundTag((DataInputStream)input));
    }

    @Override
    public void writePacketData(DataOutputStream output) throws IOException {
        if (this.itemStack == null) {
            throw new IOException("Itemstack must be set!");
        }
        super.writePacketData(output);
        PacketOpenItemGui.writeCompressedCompoundTag((CompoundTag)this.itemStack.writeToNBT(new CompoundTag()), (DataOutputStream)output);
    }

    @Override
    public int getPacketSize() {
        return super.getPacketSize() + 12;
    }
}

