/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.helper.gui.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;
import org.jetbrains.annotations.NotNull;
import turniplabs.halplibe.HalpLibe;
import turniplabs.halplibe.helper.gui.GuiHelper;
import turniplabs.halplibe.helper.gui.registered.RegisteredGui;

public class PacketOpenGui
extends Packet {
    public String guiNamespace;
    public int windowId;

    public PacketOpenGui(@NotNull RegisteredGui gui, int windowId) {
        this.guiNamespace = gui.getNamespace();
        this.windowId = windowId;
    }

    public PacketOpenGui() {
    }

    public void readPacketData(DataInputStream input) throws IOException {
        this.guiNamespace = input.readUTF();
        this.windowId = input.readByte();
    }

    public void writePacketData(DataOutputStream output) throws IOException {
        if (this.guiNamespace == null) {
            throw new IOException("GUI Namespace can't be null!");
        }
        output.writeUTF(this.guiNamespace);
        output.writeByte(this.windowId);
    }

    public void processPacket(NetHandler netHandler) {
        RegisteredGui gui = GuiHelper.getGui(this.guiNamespace);
        if (gui == null) {
            HalpLibe.LOGGER.warn("Invalid gui id in packet: " + this.guiNamespace);
            return;
        }
        gui.handleOpenPacket(this);
    }

    public int getPacketSize() {
        return this.guiNamespace.length() + 1;
    }
}

