/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.helper.gui.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.EntityPlayerSP;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.EntityPlayerMP;
import turniplabs.halplibe.HalpLibe;
import turniplabs.halplibe.helper.gui.GuiHelper;
import turniplabs.halplibe.helper.gui.registered.RegisteredGui;
import turniplabs.halplibe.util.PlayerUtils;

public class PacketGuiButtonClick
extends Packet {
    public String guiNamespace;
    public int buttonId;
    public int clickerId;

    public PacketGuiButtonClick(String guiNamespace, int buttonId, int clickerId) {
        this.guiNamespace = guiNamespace;
        this.buttonId = buttonId;
        this.clickerId = clickerId;
    }

    public PacketGuiButtonClick(String guiNamespace, int buttonId) {
        this(guiNamespace, buttonId, -1);
    }

    public PacketGuiButtonClick() {
    }

    public void readPacketData(DataInputStream input) throws IOException {
        this.guiNamespace = input.readUTF();
        this.buttonId = input.readInt();
        this.clickerId = input.readInt();
    }

    public void writePacketData(DataOutputStream output) throws IOException {
        if (this.guiNamespace == null) {
            throw new IOException("GUI Namespace can't be null!");
        }
        output.writeUTF(this.guiNamespace);
        output.writeInt(this.buttonId);
        output.writeInt(this.clickerId);
    }

    public void processPacket(NetHandler netHandler) {
        WorldClient world;
        Entity entity;
        RegisteredGui gui = GuiHelper.getGui(this.guiNamespace);
        if (gui == null) {
            HalpLibe.LOGGER.warn("Invalid gui id in packet: " + this.guiNamespace);
            return;
        }
        EntityPlayer player = PlayerUtils.getPlayer(netHandler);
        EntityPlayer clicker = null;
        if (player.craftingInventory == null) {
            return;
        }
        if (player instanceof EntityPlayerMP) {
            PacketGuiButtonClick packet = new PacketGuiButtonClick(this.guiNamespace, this.buttonId, player.id);
            clicker = player;
            for (EntityPlayerMP other : MinecraftServer.getInstance().playerList.playerEntities) {
                if (other == player || other.craftingInventory == null || other.craftingInventory.windowId != player.craftingInventory.windowId) continue;
                other.playerNetServerHandler.sendPacket((Packet)packet);
            }
        }
        if (player instanceof EntityPlayerSP && (entity = (world = (WorldClient)Minecraft.getMinecraft((Object)((Object)this)).theWorld).getEntityFromId(this.clickerId)) instanceof EntityPlayer) {
            clicker = (EntityPlayer)entity;
        }
        if (clicker != null) {
            gui.getFactory().onButtonClick(gui, player, clicker, this.buttonId);
        }
    }

    public int getPacketSize() {
        return this.guiNamespace.length() + 8;
    }
}

