/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.helper.gui.factory.block;

import net.minecraft.client.entity.player.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.player.inventory.Container;
import net.minecraft.server.entity.player.EntityPlayerMP;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import turniplabs.halplibe.helper.gui.factory.block.BlockGuiFactory;
import turniplabs.halplibe.helper.gui.registered.RegisteredGui;

public interface TileGuiFactory<T extends TileEntity>
extends BlockGuiFactory {
    @NotNull
    public GuiScreen createGui(@NotNull RegisteredGui var1, @NotNull EntityPlayerSP var2, @NotNull T var3);

    @Nullable
    public Container createContainer(@NotNull RegisteredGui var1, @NotNull EntityPlayerMP var2, @NotNull T var3);

    @Override
    @NotNull
    default public GuiScreen createGui(@NotNull RegisteredGui gui, @NotNull EntityPlayerSP player, int x, int y, int z) {
        return this.createGui(gui, player, this.getTile(gui, (EntityPlayer)player, x, y, z));
    }

    @Override
    @Nullable
    default public Container createContainer(@NotNull RegisteredGui gui, @NotNull EntityPlayerMP player, int x, int y, int z) {
        return this.createContainer(gui, player, this.getTile(gui, (EntityPlayer)player, x, y, z));
    }

    default public T getTile(@NotNull RegisteredGui gui, @NotNull EntityPlayer player, int x, int y, int z) {
        TileEntity tile = player.world.getBlockTileEntity(x, y, z);
        if (tile == null) {
            throw new IllegalStateException(String.format("Failed to find tile entity to create gui '%s' at x:%s, y:%s, z:%s", gui.getNamespace(), x, y, z));
        }
        try {
            return (T)tile;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Found wrong type of tile entity.", e);
        }
    }
}

