/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.helper.gui.factory;

import net.minecraft.client.entity.player.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.Container;
import net.minecraft.server.entity.player.EntityPlayerMP;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import turniplabs.halplibe.helper.gui.packet.PacketOpenBlockGui;
import turniplabs.halplibe.helper.gui.packet.PacketOpenGui;
import turniplabs.halplibe.helper.gui.packet.PacketOpenItemGui;
import turniplabs.halplibe.helper.gui.registered.RegisteredGui;

public interface IGuiFactory {
    @ApiStatus.Internal
    @NotNull
    public GuiScreen createGui(@NotNull RegisteredGui var1, @NotNull EntityPlayerSP var2, @Nullable ItemStack var3, int var4, int var5, int var6);

    @ApiStatus.Internal
    @Nullable
    public Container createContainer(@NotNull RegisteredGui var1, @NotNull EntityPlayerMP var2, @Nullable ItemStack var3, int var4, int var5, int var6);

    default public void onButtonClick(@NotNull RegisteredGui gui, @NotNull EntityPlayer player, @NotNull EntityPlayer clicker, int buttonId) {
    }

    @ApiStatus.Internal
    @NotNull
    default public GuiScreen createGui(@NotNull RegisteredGui gui, @NotNull EntityPlayerSP player, @NotNull PacketOpenGui packet) {
        if (!gui.isServerSide()) {
            throw new IllegalStateException("Gui is client side!");
        }
        if (packet instanceof PacketOpenBlockGui) {
            PacketOpenBlockGui blockPacket = (PacketOpenBlockGui)packet;
            return this.createGui(gui, player, null, blockPacket.x, blockPacket.y, blockPacket.z);
        }
        if (packet instanceof PacketOpenItemGui) {
            return this.createGui(gui, player, ((PacketOpenItemGui)packet).itemStack, 0, -100, 0);
        }
        return this.createGui(gui, player, null, 0, -100, 0);
    }

    @ApiStatus.Internal
    @NotNull
    default public PacketOpenGui createGuiPacket(@NotNull RegisteredGui gui, int windowId, @NotNull EntityPlayerMP player, @Nullable ItemStack itemStack, int x, int y, int z) {
        if (!gui.isServerSide()) {
            throw new IllegalStateException("Gui is client side!");
        }
        if (itemStack != null) {
            return new PacketOpenItemGui(gui, windowId, itemStack);
        }
        if (y >= 0) {
            return new PacketOpenBlockGui(gui, windowId, x, y, z);
        }
        return new PacketOpenGui(gui, windowId);
    }

    @ApiStatus.Internal
    default public void throwInvalidException(String message) {
        throw new IllegalArgumentException(String.format("Invalid arguments for gui factory '%s': %s", this.getClass(), message));
    }
}

