/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.minecraft.client.Minecraft;
import turniplabs.halplibe.HalpLibe;
import turniplabs.halplibe.util.version.EnumModList;
import turniplabs.halplibe.util.version.ModInfo;

public final class ModVersionHelper {
    protected static boolean isDev = FabricLoader.getInstance().isDevelopmentEnvironment();
    protected static List<ModInfo> localMods = new ArrayList<ModInfo>();
    protected static List<ModInfo> serverMods = null;

    public static void initialize() {
    }

    public static List<ModInfo> getLocalModlist() {
        return localMods;
    }

    public static List<ModInfo> getServerModlist() {
        if (ModVersionHelper.isClientOfServer()) {
            return serverMods;
        }
        return null;
    }

    public static List<ModInfo> getActiveModlist() {
        if (ModVersionHelper.isClientOfServer()) {
            return ModVersionHelper.getServerModlist();
        }
        return ModVersionHelper.getLocalModlist();
    }

    public static boolean isClientOfServer() {
        if (!HalpLibe.isClient) {
            return false;
        }
        Minecraft mc = Minecraft.getMinecraft(Minecraft.class);
        return mc.theWorld != null && mc.theWorld.isClientSide;
    }

    public static boolean isModPresent(String modIdToCheck) {
        return ModVersionHelper.isModPresent(modIdToCheck, EnumModList.ACTIVE);
    }

    public static boolean isModPresent(String modIdToCheck, EnumModList modList) {
        return ModVersionHelper.getModInfo(modIdToCheck, modList) != null;
    }

    public static Integer isVersionPresent(String modIdToCheck, Version version) {
        return ModVersionHelper.isVersionPresent(modIdToCheck, version, EnumModList.ACTIVE);
    }

    public static Integer isVersionPresent(String modIdToCheck, Version version, EnumModList modList) {
        ModInfo modInfo = ModVersionHelper.getModInfo(modIdToCheck, modList);
        if (modInfo == null) {
            return null;
        }
        return modInfo.version.compareTo((Object)version);
    }

    public static ModInfo getModInfo(String modId, EnumModList modList) {
        List<ModInfo> modInfoList = ModVersionHelper.getModList(modList);
        if (modInfoList == null) {
            return null;
        }
        for (ModInfo info : modInfoList) {
            if (!info.id.equals(modId)) continue;
            return info;
        }
        return null;
    }

    public static List<ModInfo> getModList(EnumModList modList) {
        switch (modList) {
            case LOCAL: {
                return ModVersionHelper.getLocalModlist();
            }
            case SERVER: {
                return ModVersionHelper.getServerModlist();
            }
            case ACTIVE: {
                return ModVersionHelper.getActiveModlist();
            }
        }
        return null;
    }

    protected static void setServerModlist(List<ModInfo> modInfos) {
        serverMods = modInfos;
        if (isDev) {
            ModVersionHelper.printModList();
        }
    }

    protected static void printModList() {
        HalpLibe.LOGGER.info("Server Mod List");
        if (ModVersionHelper.getServerModlist() != null) {
            for (ModInfo info : ModVersionHelper.getServerModlist()) {
                HalpLibe.LOGGER.info(info.id + " " + info.version);
            }
        }
    }

    public static byte[] encodeMods(List<ModInfo> modInfo) {
        byte[] bytes = new byte[]{};
        try {
            ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteOutput);
            int size = modInfo.size();
            for (int i = 0; i < size; ++i) {
                modInfo.get(i).pack(dataOutputStream);
                if (i == size - 1) {
                    dataOutputStream.writeChar(127);
                    continue;
                }
                dataOutputStream.writeChar(3);
            }
            bytes = byteOutput.toByteArray();
            byteOutput.close();
            dataOutputStream.close();
            return bytes;
        }
        catch (IOException e) {
            HalpLibe.LOGGER.error("IOException occurred in encoding!", (Throwable)e);
            return bytes;
        }
    }

    public static List<ModInfo> decodeMods(byte[] bytes) {
        try {
            ArrayList<ModInfo> modInfos = new ArrayList<ModInfo>();
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(bytes));
            int data = 0;
            while (data != 127) {
                modInfos.add(new ModInfo(dataInputStream));
                data = dataInputStream.readChar();
            }
            return modInfos;
        }
        catch (IOException e) {
            HalpLibe.LOGGER.error("IOException occurred in decoding!", (Throwable)e);
            return new ArrayList<ModInfo>();
        }
    }

    static {
        for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
            if (!modContainer.getMetadata().getType().equals("fabric") || modContainer.getMetadata().getId().equals("fabricloader")) continue;
            localMods.add(new ModInfo(modContainer));
        }
    }
}

