/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelStandard;
import net.minecraft.core.block.Block;
import net.minecraft.core.item.Item;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import turniplabs.halplibe.helper.ItemBuilder;
import turniplabs.halplibe.helper.RegistryHelper;
import turniplabs.halplibe.util.registry.IdSupplier;
import turniplabs.halplibe.util.registry.RunLengthConfig;
import turniplabs.halplibe.util.registry.RunReserves;
import turniplabs.halplibe.util.toml.Toml;

public final class ItemHelper {
    public static <T extends Item> T createItem(@NotNull String modId, @NotNull T item) {
        return ItemHelper.createItem(modId, item, i -> new ItemModelStandard(i, modId));
    }

    public static <T extends Item> T createItem(@NotNull String modId, @NotNull T item, @NotNull Function<Item, ItemModel> itemModelSupplier) {
        List tokens = Arrays.stream(item.getKey().split("\\.")).collect(Collectors.toList());
        ArrayList<String> newTokens = new ArrayList<String>();
        newTokens.add(modId);
        newTokens.addAll(tokens.subList(1, tokens.size()));
        ItemBuilder.Assignment.queueItemModel(item, itemModelSupplier, null);
        return (T)item.setKey(StringUtils.join(newTokens, (String)"."));
    }

    public static class Registry {
        public static int highestVanilla;
        private static final RunReserves reserves;

        public static int findOpenIds(int count) {
            int run = 0;
            for (int i = Block.blocksList.length + 1; i < Item.itemsList.length; ++i) {
                if (Item.itemsList[i] == null && !reserves.isReserved(i)) {
                    if (run >= count) {
                        return i - run;
                    }
                    ++run;
                    continue;
                }
                run = 0;
            }
            return -1;
        }

        public static int findLength(int id, int terminate) {
            int run = 0;
            for (int i = id; i < Item.itemsList.length; ++i) {
                if (Item.itemsList[i] == null && !reserves.isReserved(i)) {
                    if (++run < terminate) continue;
                    return terminate;
                }
                return run;
            }
            return run;
        }

        public static void reserveRuns(String modId, Toml runs, int neededIds, Consumer<IdSupplier> function) {
            RunLengthConfig cfg = new RunLengthConfig(runs, neededIds);
            cfg.register(reserves);
            RegistryHelper.scheduleSmartRegistry(() -> {
                IdSupplier supplier = new IdSupplier(modId, reserves, cfg, neededIds);
                function.accept(supplier);
                supplier.validate();
            });
        }

        static {
            reserves = new RunReserves(Registry::findOpenIds, Registry::findLength);
        }
    }
}

