/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.helper;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.item.model.ItemModelStandard;
import net.minecraft.client.render.stitcher.TextureRegistry;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.item.Item;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import turniplabs.halplibe.HalpLibe;

public final class ItemBuilder
implements Cloneable {
    private final String modId;
    @Nullable
    private String overrideKey = null;
    @Nullable
    private String textureKey = null;
    @Nullable
    private Tag<Item>[] tags = null;
    private Integer stackSize = null;
    private Integer maxDamage = null;
    @Nullable
    private Supplier<Item> containerItemSupplier = null;
    @NotNull
    private Function<Item, ItemModel> customItemModelSupplier;

    public ItemBuilder(String modId) {
        this.modId = modId;
        this.customItemModelSupplier = item -> new ItemModelStandard(item, null);
    }

    public ItemBuilder clone() {
        try {
            return (ItemBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public ItemBuilder setItemModel(Function<Item, ItemModel> modelSupplier) {
        ItemBuilder builder = this.clone();
        builder.customItemModelSupplier = modelSupplier;
        return builder;
    }

    public ItemBuilder setIcon(String iconKey) {
        ItemBuilder builder = this.clone();
        builder.textureKey = iconKey;
        return builder;
    }

    public ItemBuilder setKey(String key) {
        ItemBuilder builder = this.clone();
        builder.overrideKey = key;
        return builder;
    }

    public ItemBuilder setStackSize(int stackSize) {
        ItemBuilder builder = this.clone();
        builder.stackSize = stackSize;
        return builder;
    }

    public ItemBuilder setMaxDamage(int maxDamage) {
        ItemBuilder builder = this.clone();
        builder.maxDamage = maxDamage;
        return builder;
    }

    public ItemBuilder setContainerItem(Supplier<Item> itemSupplier) {
        ItemBuilder builder = this.clone();
        builder.containerItemSupplier = itemSupplier;
        return builder;
    }

    @SafeVarargs
    public final ItemBuilder setTags(Tag<Item> ... tags) {
        ItemBuilder itemBuilder = this.clone();
        itemBuilder.tags = tags;
        return itemBuilder;
    }

    @SafeVarargs
    public final ItemBuilder addTags(Tag<Item> ... tags) {
        ItemBuilder itemBuilder = this.clone();
        itemBuilder.tags = (Tag[])ArrayUtils.addAll((Object[])this.tags, (Object[])tags);
        return itemBuilder;
    }

    public <T extends Item> T build(T item) {
        List tokens = this.overrideKey != null ? Arrays.stream(this.overrideKey.split("\\.")).collect(Collectors.toList()) : Arrays.stream(item.getKey().split("\\.")).collect(Collectors.toList());
        if (this.tags != null) {
            item.withTags(this.tags);
        }
        if (this.stackSize != null) {
            item.setMaxStackSize(this.stackSize.intValue());
        }
        if (this.containerItemSupplier != null) {
            item.setContainerItem(this.containerItemSupplier.get());
        }
        if (this.maxDamage != null) {
            try {
                item.getClass().getMethod("setMaxDamage", Integer.TYPE).invoke(item, this.maxDamage);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList<String> newTokens = new ArrayList<String>();
        newTokens.add(this.modId);
        newTokens.addAll(tokens.subList(1, tokens.size()));
        Assignment.queueItemModel(item, this.customItemModelSupplier, this.textureKey);
        item.setKey(StringUtils.join(newTokens, (String)"."));
        return item;
    }

    public static class Assignment {
        public static boolean itemDispatcherInitialized = false;
        public static final List<ItemAssignmentEntry<?>> queuedItemModels = new ArrayList();

        public static <T extends Item> void queueItemModel(@NotNull T item, @NotNull Function<T, ItemModel> itemModelSupplier, @Nullable String iconTexture) {
            if (!HalpLibe.isClient) {
                return;
            }
            if (itemDispatcherInitialized) {
                ItemModelDispatcher.getInstance().addDispatch(new ItemAssignmentEntry<T>(item, itemModelSupplier, iconTexture).getModel());
                return;
            }
            queuedItemModels.add(new ItemAssignmentEntry<T>(item, itemModelSupplier, iconTexture));
        }

        public static class ItemAssignmentEntry<T extends Item> {
            public final T item;
            public final Function<T, ItemModel> modelFunction;
            public final String iconKey;

            public ItemAssignmentEntry(T item, Function<T, ItemModel> modelFunction, String iconKey) {
                this.item = item;
                this.modelFunction = modelFunction;
                this.iconKey = iconKey;
            }

            public ItemModel getModel() {
                ItemModel model = this.modelFunction.apply(this.item);
                if (model instanceof ItemModelStandard && this.iconKey != null) {
                    ((ItemModelStandard)model).icon = TextureRegistry.getTexture((String)this.iconKey);
                    return model;
                }
                if (model instanceof ItemModelStandard && ((ItemModelStandard)model).icon == ItemModelStandard.ITEM_TEXTURE_UNASSIGNED) {
                    String namespace = this.item.getKey().split("\\.")[1];
                    ((ItemModelStandard)model).icon = TextureRegistry.getTexture((String)String.format("%s:item/%s", namespace, this.item.getKey().replaceFirst("item." + namespace + ".", "").replace(".", "_")));
                    return model;
                }
                return model;
            }
        }
    }
}

