/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.Commands;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import turniplabs.halplibe.HalpLibe;

public final class CommandHelper {
    @ApiStatus.Internal
    private static final List<Command> coreCommands = new ArrayList<Command>();
    @ApiStatus.Internal
    private static final List<Function<AtomicReference<Minecraft>, Command>> clientCommands = new ArrayList<Function<AtomicReference<Minecraft>, Command>>();
    @ApiStatus.Internal
    private static final List<Function<AtomicReference<MinecraftServer>, Command>> serverCommands = new ArrayList<Function<AtomicReference<MinecraftServer>, Command>>();

    public static void createCommand(Command command) {
        coreCommands.add(command);
        if (!Commands.commands.isEmpty()) {
            Commands.commands.add(command);
        }
    }

    public static void createClientCommand(Function<AtomicReference<Minecraft>, Command> clientCommand) {
        if (!HalpLibe.isClient) {
            return;
        }
        clientCommands.add(clientCommand);
        if (!Commands.commands.isEmpty()) {
            Commands.commands.add(clientCommand.apply(new AtomicReference<Minecraft>(Minecraft.getMinecraft(Minecraft.class))));
        }
    }

    public static void createServerCommand(Function<AtomicReference<MinecraftServer>, Command> serverCommand) {
        if (HalpLibe.isClient) {
            return;
        }
        serverCommands.add(serverCommand);
        if (!Commands.commands.isEmpty()) {
            Commands.commands.add(serverCommand.apply(new AtomicReference<MinecraftServer>(MinecraftServer.getInstance())));
        }
    }
}

