/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelBlock;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.client.render.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockFire;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.sound.BlockSound;
import net.minecraft.core.sound.BlockSoundDispatcher;
import net.minecraft.core.util.helper.Side;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import turniplabs.halplibe.HalpLibe;
import turniplabs.halplibe.helper.ItemBuilder;
import turniplabs.halplibe.helper.RegistryHelper;
import turniplabs.halplibe.util.registry.IdSupplier;
import turniplabs.halplibe.util.registry.RunLengthConfig;
import turniplabs.halplibe.util.registry.RunReserves;
import turniplabs.halplibe.util.toml.Toml;

public final class BlockBuilder
implements Cloneable {
    private final String MOD_ID;
    private Float hardness = null;
    private Float resistance = null;
    private Integer luminance = null;
    private Integer lightOpacity = null;
    private Float slipperiness = null;
    private boolean immovable = false;
    private boolean useInternalLight = false;
    private boolean visualUpdateOnMetadata = false;
    private Boolean tickOnLoad = null;
    private boolean infiniburn = false;
    private int[] flammability = null;
    private Block blockDrop = null;
    private BlockSound blockSound = null;
    private Function<Block, BlockColor> blockColor = null;
    @NotNull
    private Function<Block, BlockModel<?>> blockModelSupplier = BlockModelStandard::new;
    @NotNull
    private Function<ItemBlock, ItemModel> customItemModelSupplier = ItemModelBlock::new;
    private BlockLambda<ItemBlock> customItemBlock = null;
    private Tag<Block>[] tags = null;
    @NotNull
    private String[] textures = new String[6];
    @Nullable
    private String itemIcon = null;

    public BlockBuilder(String modId) {
        this.MOD_ID = modId;
    }

    public BlockBuilder clone() {
        try {
            BlockBuilder builder = (BlockBuilder)super.clone();
            builder.textures = new String[6];
            System.arraycopy(this.textures, 0, builder.textures, 0, this.textures.length);
            return builder;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public BlockBuilder setTopTexture(String texture) {
        BlockBuilder builder = this.clone();
        builder.textures[Side.TOP.getId()] = texture;
        return builder;
    }

    public BlockBuilder setBottomTexture(String texture) {
        BlockBuilder builder = this.clone();
        builder.textures[Side.BOTTOM.getId()] = texture;
        return builder;
    }

    public BlockBuilder setNorthTexture(String texture) {
        BlockBuilder builder = this.clone();
        builder.textures[Side.NORTH.getId()] = texture;
        return builder;
    }

    public BlockBuilder setSouthTexture(String texture) {
        BlockBuilder builder = this.clone();
        builder.textures[Side.SOUTH.getId()] = texture;
        return builder;
    }

    public BlockBuilder setWestTexture(String texture) {
        BlockBuilder builder = this.clone();
        builder.textures[Side.WEST.getId()] = texture;
        return builder;
    }

    public BlockBuilder setEastTexture(String texture) {
        BlockBuilder builder = this.clone();
        builder.textures[Side.EAST.getId()] = texture;
        return builder;
    }

    public BlockBuilder setTextures(String texture) {
        BlockBuilder builder = this.clone();
        builder.textures[Side.TOP.getId()] = texture;
        builder.textures[Side.BOTTOM.getId()] = texture;
        builder.textures[Side.NORTH.getId()] = texture;
        builder.textures[Side.SOUTH.getId()] = texture;
        builder.textures[Side.WEST.getId()] = texture;
        builder.textures[Side.EAST.getId()] = texture;
        return builder;
    }

    public BlockBuilder setSideTextures(String texture) {
        BlockBuilder builder = this.clone();
        builder.textures[Side.NORTH.getId()] = texture;
        builder.textures[Side.SOUTH.getId()] = texture;
        builder.textures[Side.WEST.getId()] = texture;
        builder.textures[Side.EAST.getId()] = texture;
        return builder;
    }

    public BlockBuilder setTopBottomTextures(String texture) {
        BlockBuilder builder = this.clone();
        builder.textures[Side.TOP.getId()] = texture;
        builder.textures[Side.BOTTOM.getId()] = texture;
        return builder;
    }

    public BlockBuilder setNorthSouthTextures(String texture) {
        BlockBuilder builder = this.clone();
        builder.textures[Side.NORTH.getId()] = texture;
        builder.textures[Side.SOUTH.getId()] = texture;
        return builder;
    }

    public BlockBuilder setEastWestTextures(String texture) {
        BlockBuilder builder = this.clone();
        builder.textures[Side.WEST.getId()] = texture;
        builder.textures[Side.EAST.getId()] = texture;
        return builder;
    }

    public BlockBuilder setIcon(String iconKey) {
        BlockBuilder builder = this.clone();
        builder.itemIcon = iconKey;
        return builder;
    }

    public BlockBuilder setHardness(float hardness) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.hardness = Float.valueOf(hardness);
        return blockBuilder;
    }

    public BlockBuilder setResistance(float resistance) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.resistance = Float.valueOf(resistance);
        return blockBuilder;
    }

    public BlockBuilder setLuminance(int luminance) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.luminance = luminance;
        return blockBuilder;
    }

    public BlockBuilder setLightOpacity(int lightOpacity) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.lightOpacity = lightOpacity;
        return blockBuilder;
    }

    public BlockBuilder setSlipperiness(float slipperiness) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.slipperiness = Float.valueOf(slipperiness);
        return blockBuilder;
    }

    public BlockBuilder setFlammability(int chanceToCatchFire, int chanceToDegrade) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.flammability = new int[]{chanceToCatchFire, chanceToDegrade};
        return blockBuilder;
    }

    public BlockBuilder setImmovable() {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.immovable = true;
        return blockBuilder;
    }

    public BlockBuilder setUnbreakable() {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.hardness = Float.valueOf(-1.0f);
        return blockBuilder;
    }

    public BlockBuilder setInfiniburn() {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.infiniburn = true;
        return blockBuilder;
    }

    public BlockBuilder setUseInternalLight() {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.useInternalLight = true;
        return blockBuilder;
    }

    public BlockBuilder setVisualUpdateOnMetadata() {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.visualUpdateOnMetadata = true;
        return blockBuilder;
    }

    public BlockBuilder setTickOnLoad() {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.tickOnLoad = true;
        return blockBuilder;
    }

    public BlockBuilder setTicking(boolean ticking) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.tickOnLoad = ticking;
        return blockBuilder;
    }

    public BlockBuilder setBlockDrop(Block droppedBlock) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.blockDrop = droppedBlock;
        return blockBuilder;
    }

    public BlockBuilder setBlockSound(BlockSound blockSound) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.blockSound = blockSound;
        return blockBuilder;
    }

    public BlockBuilder setBlockColor(Function<Block, BlockColor> blockColorSupplier) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.blockColor = blockColorSupplier;
        return blockBuilder;
    }

    public BlockBuilder setBlockModel(@NotNull Function<Block, BlockModel<?>> blockModelSupplier) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.blockModelSupplier = blockModelSupplier;
        return blockBuilder;
    }

    public BlockBuilder setItemModel(@NotNull Function<ItemBlock, ItemModel> itemModelSupplier) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.customItemModelSupplier = itemModelSupplier;
        return blockBuilder;
    }

    public BlockBuilder setItemBlock(BlockLambda<ItemBlock> customItemBlock) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.customItemBlock = customItemBlock;
        return blockBuilder;
    }

    @SafeVarargs
    public final BlockBuilder setTags(Tag<Block> ... tags) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.tags = tags;
        return blockBuilder;
    }

    @SafeVarargs
    public final BlockBuilder addTags(Tag<Block> ... tags) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.tags = (Tag[])ArrayUtils.addAll((Object[])this.tags, (Object[])tags);
        return blockBuilder;
    }

    public <T extends Block> T build(T block) {
        ItemBlock itemBlock;
        if (this.hardness != null) {
            block.withHardness(this.hardness.floatValue());
        }
        if (this.resistance != null) {
            block.withBlastResistance(this.resistance.floatValue());
        }
        if (this.luminance != null) {
            block.withLightEmission(this.luminance.intValue());
        }
        if (this.lightOpacity != null) {
            block.withLightBlock(this.lightOpacity.intValue());
        }
        if (this.slipperiness != null) {
            block.movementScale = this.slipperiness.floatValue();
        }
        block.withLitInteriorSurface(this.useInternalLight);
        if (this.immovable) {
            block.withImmovableFlagSet();
        }
        if (this.flammability != null) {
            BlockFire.setBurnRate((int)block.id, (int)this.flammability[0], (int)this.flammability[1]);
        }
        if (this.infiniburn) {
            block.withTags(new Tag[]{BlockTags.INFINITE_BURN});
        }
        if (this.visualUpdateOnMetadata) {
            block.withDisabledNeighborNotifyOnMetadataChange();
        }
        if (this.tickOnLoad != null) {
            block.setTicking(this.tickOnLoad.booleanValue());
        }
        if (this.blockDrop != null) {
            block.setDropOverride(this.blockDrop.id);
        }
        if (this.blockSound != null) {
            BlockSoundDispatcher.getInstance().addDispatch(block, (Object)this.blockSound);
        }
        Assignment.queueBlockColor(block, this.blockColor);
        if (this.customItemBlock != null) {
            itemBlock = this.customItemBlock.run(block);
            Item.itemsList[block.id] = itemBlock;
        } else {
            itemBlock = new ItemBlock(block);
            Item.itemsList[block.id] = itemBlock;
        }
        if (this.tags != null) {
            block.withTags(this.tags);
        }
        Assignment.queueBlockModel(block, this.blockModelSupplier, this.textures);
        ItemBuilder.Assignment.queueItemModel(itemBlock, this.customItemModelSupplier, this.itemIcon);
        List tokens = Arrays.stream(block.getKey().split("\\.")).filter(token -> !token.equals(this.MOD_ID)).collect(Collectors.toList());
        ArrayList<String> newTokens = new ArrayList<String>();
        newTokens.add(this.MOD_ID);
        newTokens.addAll(tokens.subList(1, tokens.size()));
        block.setKey(StringUtils.join(newTokens, (char)'.'));
        return block;
    }

    @FunctionalInterface
    public static interface BlockLambda<T> {
        public T run(Block var1);
    }

    public static class Assignment {
        public static boolean blockDispatcherInitialized = false;
        public static final List<BlockAssignmentEntry<?>> queuedBlockModels = new ArrayList();
        public static boolean blockColorDispatcherInitialized = false;
        public static final Map<Block, Function<Block, BlockColor>> queuedBlockColors = new LinkedHashMap<Block, Function<Block, BlockColor>>();

        public static <T extends Block> void queueBlockModel(@NotNull T block, Function<T, BlockModel<?>> blockModelSupplier, @Nullable String[] textures) {
            if (!HalpLibe.isClient) {
                return;
            }
            if (blockModelSupplier == null) {
                return;
            }
            if (blockDispatcherInitialized) {
                BlockModelDispatcher.getInstance().addDispatch(new BlockAssignmentEntry<T>(block, blockModelSupplier, textures).getModel());
                return;
            }
            queuedBlockModels.add(new BlockAssignmentEntry<T>(block, blockModelSupplier, textures));
        }

        public static void queueBlockColor(@NotNull Block block, Function<Block, BlockColor> blockColorSupplier) {
            if (!HalpLibe.isClient) {
                return;
            }
            if (blockColorSupplier == null) {
                return;
            }
            if (blockColorDispatcherInitialized) {
                BlockColorDispatcher.getInstance().addDispatch((Object)block, (Object)blockColorSupplier.apply(block));
                return;
            }
            queuedBlockColors.put(block, blockColorSupplier);
        }

        public static class BlockAssignmentEntry<T extends Block> {
            public final T block;
            public final Function<T, BlockModel<?>> modelFunction;
            public final String[] textures;

            public BlockAssignmentEntry(@NotNull T block, @NotNull Function<T, BlockModel<?>> modelFunction, @Nullable String[] textures) {
                this.block = block;
                this.modelFunction = modelFunction;
                this.textures = textures;
            }

            public BlockModel<?> getModel() {
                BlockModel<?> model = this.modelFunction.apply(this.block);
                if (model instanceof BlockModelStandard && this.textures != null) {
                    IconCoordinate[] atlasIndices = ((BlockModelStandard)model).atlasIndices;
                    for (int i = 0; i < atlasIndices.length; ++i) {
                        if (this.textures[i] == null) continue;
                        atlasIndices[i] = TextureRegistry.getTexture((String)this.textures[i]);
                    }
                }
                return model;
            }
        }
    }

    public static class Registry {
        public static int highestVanilla;
        private static final RunReserves reserves;

        public static int findOpenIds(int count) {
            int run = 0;
            for (int i = highestVanilla; i < Block.blocksList.length; ++i) {
                if (Block.blocksList[i] == null && !reserves.isReserved(i)) {
                    if (run >= count) {
                        return i - run;
                    }
                    ++run;
                    continue;
                }
                run = 0;
            }
            return -1;
        }

        public static int findLength(int id, int terminate) {
            int run = 0;
            for (int i = id; i < Block.blocksList.length; ++i) {
                if (Block.blocksList[i] == null && !reserves.isReserved(i)) {
                    if (++run < terminate) continue;
                    return terminate;
                }
                return run;
            }
            return run;
        }

        public static void reserveRuns(String modId, Toml runs, int neededIds, Consumer<IdSupplier> function) {
            RunLengthConfig cfg = new RunLengthConfig(runs, neededIds);
            cfg.register(reserves);
            RegistryHelper.scheduleSmartRegistry(() -> {
                IdSupplier supplier = new IdSupplier(modId, reserves, cfg, neededIds);
                function.accept(supplier);
                supplier.validate();
            });
        }

        static {
            reserves = new RunReserves(Registry::findOpenIds, Registry::findLength);
        }
    }
}

