/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe;

import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import net.minecraft.core.block.Block;
import net.minecraft.core.item.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import turniplabs.halplibe.helper.AchievementHelper;
import turniplabs.halplibe.helper.ModVersionHelper;
import turniplabs.halplibe.helper.NetworkHelper;
import turniplabs.halplibe.helper.gui.packet.PacketGuiButtonClick;
import turniplabs.halplibe.helper.gui.packet.PacketOpenBlockGui;
import turniplabs.halplibe.helper.gui.packet.PacketOpenGui;
import turniplabs.halplibe.helper.gui.packet.PacketOpenItemGui;
import turniplabs.halplibe.util.TomlConfigHandler;
import turniplabs.halplibe.util.achievements.AchievementPage;
import turniplabs.halplibe.util.achievements.VanillaAchievementsPage;
import turniplabs.halplibe.util.toml.Toml;

public class HalpLibe
implements ModInitializer,
PreLaunchEntrypoint {
    public static final String MOD_ID = "halplibe";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"halplibe");
    public static final boolean isClient = FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.CLIENT);
    public static boolean exportRecipes;
    public static boolean compatibilityMode;
    public static final TomlConfigHandler CONFIG;
    public static final AchievementPage VANILLA_ACHIEVEMENTS;
    public static HashMap<String, Integer> itemKeyToIdMap;

    public static int getTrueItemOrBlockId(String key) {
        if (itemKeyToIdMap.containsKey(key)) {
            return itemKeyToIdMap.get(key);
        }
        if (key.startsWith("item")) {
            for (Item item : Item.itemsList) {
                if (item == null || item.getKey() == null || item.getKey().isEmpty()) continue;
                itemKeyToIdMap.put(item.getKey(), item.id);
                if (!item.getKey().matches(key)) continue;
                return item.id;
            }
            throw new IllegalArgumentException("Could not find an item that corresponds to the key '" + key + "'");
        }
        if (key.startsWith("tile")) {
            for (Block item : Block.blocksList) {
                if (item == null || item.getKey() == null || item.getKey().isEmpty()) continue;
                itemKeyToIdMap.put(item.getKey(), item.id);
                if (!item.getKey().matches(key)) continue;
                return item.id;
            }
            throw new IllegalArgumentException("Could not find a block that corresponds to the key '" + key + "'");
        }
        throw new IllegalArgumentException("Key '" + key + "' does not start with a valid predicate of 'item' or 'tile'");
    }

    @Deprecated
    public static String addModId(String modId, String name) {
        return modId + "." + name;
    }

    public void onInitialize() {
        AchievementHelper.addPage(VANILLA_ACHIEVEMENTS);
        NetworkHelper.register(PacketOpenGui.class, false, true);
        NetworkHelper.register(PacketOpenItemGui.class, false, true);
        NetworkHelper.register(PacketOpenBlockGui.class, false, true);
        NetworkHelper.register(PacketGuiButtonClick.class, true, true);
        LOGGER.info("HalpLibe initialized.");
    }

    public void onPreLaunch() {
        try {
            Class.forName("net.minecraft.core.block.Block");
            Class.forName("net.minecraft.core.item.Item");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    static {
        Toml toml = new Toml();
        toml.addCategory("Experimental");
        toml.addEntry("Experimental.CompatibilityMode", "Attempt allowing compatibility with older halplibe versions", true);
        toml.addCategory("Debug");
        toml.addEntry("Debug.ExportRecipes", "Writes all the loaded game recipes to dumpRecipes after startup", false);
        CONFIG = new TomlConfigHandler(MOD_ID, toml);
        exportRecipes = CONFIG.getBoolean("Debug.ExportRecipes");
        compatibilityMode = CONFIG.getBoolean("Experimental.CompatibilityMode");
        ModVersionHelper.initialize();
        VANILLA_ACHIEVEMENTS = new VanillaAchievementsPage();
        itemKeyToIdMap = new HashMap();
    }
}

