/*
 * Decompiled with CFR 0.152.
 */
package b100.utils;

import b100.utils.StringReader;
import b100.utils.StringWriter;
import java.io.PrintStream;
import java.util.List;

public class InvalidCharacterException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private StringReader reader;
    private int line = 1;
    private int column = 1;

    public InvalidCharacterException(StringReader stringReader) {
        this.reader = stringReader;
        String string = this.reader.string();
        int i = 0;
        while (i < this.reader.position()) {
            char c = string.charAt(i);
            if (c == '\n') {
                ++this.line;
                this.column = 1;
            } else {
                ++this.column;
            }
            ++i;
        }
    }

    public String getLinePreview() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.writeln(this.getMessage());
        stringWriter.writeln();
        List<String> lines = this.reader.lines();
        int startLine = Math.max(0, this.line - 4);
        int endLine = Math.min(lines.size() - 1, this.line);
        int i = startLine;
        while (i < endLine) {
            String line = lines.get(i);
            stringWriter.writeln(line);
            if (i + 1 == this.line) {
                int j = 0;
                while (j < line.length()) {
                    int l = InvalidCharacterException.getPrintChar(line.charAt(j), true).length();
                    boolean thisChar = j + 1 == this.column;
                    int k = 0;
                    while (k < l) {
                        stringWriter.write(thisChar ? (char)'^' : ' ');
                        ++k;
                    }
                    ++j;
                }
                stringWriter.writeln();
            }
            ++i;
        }
        return stringWriter.toString();
    }

    @Override
    public String getMessage() {
        return "Invalid character \"" + InvalidCharacterException.getPrintChar(this.reader.get(), false) + "\" at line " + this.line + " column " + this.column + " (index " + this.reader.position() + ")";
    }

    public static String getPrintChar(char c, boolean a) {
        if (c == '\\') {
            return a ? "\\" : "\\\\";
        }
        if (c == '\n') {
            return a ? " " : "\\n";
        }
        if (c == '\t') {
            return a ? " " : "\\t";
        }
        return "" + c;
    }

    @Override
    public void printStackTrace(PrintStream s) {
        try {
            s.println(this.getLinePreview());
        }
        catch (Exception e) {
            s.println("Could not create line preview: " + e.getClass().getName() + ": " + e.getMessage());
        }
        super.printStackTrace(s);
    }
}

