/*
 * Decompiled with CFR 0.152.
 */
package b100.asmloader.internal;

import b100.asmloader.ClassTransformer;
import b100.asmloader.internal.Log;
import b100.asmloader.internal.ModInfo;
import b100.json.element.JsonArray;
import b100.json.element.JsonElement;
import b100.json.element.JsonObject;
import b100.utils.StringReader;
import b100.utils.StringUtils;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class LoaderUtils {
    private Log logObj;

    public LoaderUtils(Log logObj) {
        this.logObj = logObj;
    }

    public List<File> findAllModFilesOnClassPath() {
        ArrayList<File> modFiles = new ArrayList<File>();
        String[] classPathEntries = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
        int i = 0;
        while (i < classPathEntries.length) {
            File file = new File(classPathEntries[i]);
            if (this.peepModJson(file)) {
                modFiles.add(file);
            }
            ++i;
        }
        return modFiles;
    }

    public List<File> findAllModFilesInDirectory(File directory) {
        ArrayList<File> modFiles = new ArrayList<File>();
        if (!directory.exists() || !directory.isDirectory()) {
            return modFiles;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return modFiles;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            String name = file.getName();
            if (file.isFile() && (name.endsWith(".zip") || name.endsWith(".jar")) && this.peepModJson(file)) {
                modFiles.add(file);
            }
            ++i;
        }
        return modFiles;
    }

    /*
     * Loose catch block
     */
    public boolean peepModJson(File file) {
        if (file.isDirectory()) {
            File modJson = new File(file, "asmloader.mod.json");
            if (modJson.exists()) {
                return true;
            }
        } else if (file.isFile()) {
            ZipFile zipFile = null;
            zipFile = new ZipFile(file);
            boolean bl = zipFile.getEntry("asmloader.mod.json") != null;
            try {
                zipFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bl;
            catch (Exception e) {
                try {
                    zipFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
                catch (Throwable throwable) {
                    try {
                        zipFile.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return false;
    }

    public void printModFiles(List<File> allModFiles) {
        if (allModFiles.size() > 0) {
            if (allModFiles.size() == 1) {
                this.log("Found 1 mod file:");
            } else {
                this.log("Found " + allModFiles.size() + " mod files:");
            }
            for (File file : allModFiles) {
                this.log("    " + file.getAbsolutePath());
            }
        } else {
            this.log("No mods found!");
        }
    }

    public ModInfo readModInfo(File modFile, boolean isOnClassPath) {
        try {
            String modJsonString;
            if (modFile.isDirectory()) {
                File modJsonFile = new File(modFile, "asmloader.mod.json");
                if (!modJsonFile.exists() || !modJsonFile.isFile()) {
                    throw new RuntimeException("Mod json does not exist: '" + modJsonFile.getAbsolutePath() + "'!");
                }
                modJsonString = StringUtils.getFileContentAsString(modJsonFile);
            } else {
                ZipFile modZipFile = null;
                InputStream in = null;
                try {
                    modZipFile = new ZipFile(modFile);
                    ZipEntry modJsonEntry = modZipFile.getEntry("asmloader.mod.json");
                    if (modJsonEntry == null) {
                        throw new NullPointerException("No mod json in zip file!");
                    }
                    in = modZipFile.getInputStream(modJsonEntry);
                    modJsonString = StringUtils.readInputString(in);
                }
                finally {
                    try {
                        modZipFile.close();
                    }
                    catch (Exception exception) {}
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
            JsonObject modJson = new JsonObject(new StringReader(modJsonString));
            String modid = modJson.getString("modid");
            if (modid == null) {
                throw new NullPointerException("No Mod ID in asmloader.mod.json!");
            }
            String version = modJson.has("version") ? modJson.getString("version") : null;
            ArrayList<String> transformers = null;
            if (modJson.has("transformers")) {
                try {
                    transformers = this.getJsonArrayAsStringList(modJson.getArray("transformers"));
                }
                catch (Exception e) {
                    throw new RuntimeException("Error reading transformer array!", e);
                }
            } else {
                transformers = new ArrayList();
            }
            return new ModInfo(modFile, modid, version, transformers, isOnClassPath);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading mod: '" + modFile.getAbsolutePath() + "'!", e);
        }
    }

    public List<String> getJsonArrayAsStringList(JsonArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(jsonArray.length());
        int i = 0;
        while (i < jsonArray.length()) {
            JsonElement element = jsonArray.get(i);
            if (!element.isString()) {
                throw new RuntimeException("Element at index " + i + " is not a String!");
            }
            list.add(element.getAsString().value);
            ++i;
        }
        return list;
    }

    public void checkModSet(List<ModInfo> mods) {
        int i = 0;
        while (i < mods.size()) {
            ModInfo modInfo = mods.get(i);
            int j = 0;
            while (j < mods.size()) {
                if (j != i) {
                    ModInfo otherModInfo = mods.get(j);
                    if (modInfo.modid.equalsIgnoreCase(otherModInfo.modid)) {
                        throw new RuntimeException("Duplicate Mod ID '" + modInfo.modid + "' in files '" + modInfo.file.getAbsolutePath() + "' and '" + otherModInfo.file.getAbsolutePath() + "'!");
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void loadClassTransformers(ClassLoader classLoader, ModInfo modInfo, List<ClassTransformer> classTransformers) {
        if (modInfo.transformerClasses == null || modInfo.transformerClasses.size() == 0) {
            return;
        }
        Class<ClassTransformer> classTransformerClass = ClassTransformer.class;
        try {
            int i = 0;
            while (i < modInfo.transformerClasses.size()) {
                String transformerClassName = modInfo.transformerClasses.get(i);
                Class<?> transformerClass = classLoader.loadClass(transformerClassName);
                boolean isTransformerClass = false;
                boolean hasTransformerSubClasses = false;
                Object instance = transformerClass.getDeclaredConstructors()[0].newInstance(new Object[0]);
                if (instance instanceof ClassTransformer) {
                    isTransformerClass = true;
                    ClassTransformer classTransformer = (ClassTransformer)instance;
                    classTransformers.add(classTransformer);
                }
                Class<?>[] subClasses = transformerClass.getDeclaredClasses();
                int j = 0;
                while (j < subClasses.length) {
                    Class<?> subClass = subClasses[j];
                    if (classTransformerClass.isAssignableFrom(subClass)) {
                        hasTransformerSubClasses = true;
                        Object subClassInstance = null;
                        Constructor<?> constructor = subClass.getDeclaredConstructors()[0];
                        if (!constructor.isAccessible()) {
                            constructor.setAccessible(true);
                        }
                        if (constructor.getParameterCount() == 0) {
                            subClassInstance = constructor.newInstance(new Object[0]);
                        }
                        if (constructor.getParameterCount() == 1) {
                            subClassInstance = constructor.newInstance(instance);
                        }
                        ClassTransformer classTransformer = subClassInstance;
                        classTransformers.add(classTransformer);
                    }
                    ++j;
                }
                if (!isTransformerClass && !hasTransformerSubClasses) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Invalid transformer entry '" + transformerClassName + "'!\n");
                    msg.append("\nNo valid ClassTransformer was found in class!\n");
                    msg.append("\nClass '" + transformerClass.getName() + "' extends class '" + transformerClass.getSuperclass().getName() + "', loaded by ClassLoader '" + transformerClass.getSuperclass().getClassLoader() + "'!");
                    int j2 = 0;
                    while (j2 < subClasses.length) {
                        Class<?> subClass = subClasses[j2];
                        msg.append("\nSubclass '" + subClass.getName() + "' extends class '" + subClass.getSuperclass().getName() + "', loaded by ClassLoader '" + subClass.getSuperclass().getClassLoader() + "'!");
                        ++j2;
                    }
                    msg.append("\n\nTransformer classes have to extend '" + classTransformerClass.getName() + "', loaded by ClassLoader '" + classTransformerClass.getClassLoader() + "'!");
                    throw new RuntimeException(msg.toString());
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading class transformers from mod '" + modInfo.modid + "'!", e);
        }
    }

    public void printClassTransformers(List<ClassTransformer> classTransformers, Map<ClassTransformer, ModInfo> classTransformerToModMap) {
        if (classTransformers.size() == 0) {
            this.log("No class transformers loaded!");
            return;
        }
        if (classTransformers.size() == 1) {
            this.log("Loaded 1 class transformer:");
        } else {
            this.log("Loaded " + classTransformers.size() + " class transformers:");
        }
        int i = 0;
        while (i < classTransformers.size()) {
            ClassTransformer classTransformer = classTransformers.get(i);
            ModInfo modInfo = classTransformerToModMap.get(classTransformer);
            if (modInfo == null) {
                throw new NullPointerException("ModInfo for transformer '" + classTransformer + "' is null!");
            }
            this.log("    " + classTransformer.getClass().getName() + " " + modInfo.modid);
            ++i;
        }
    }

    public List<File> toList(File[] files) {
        ArrayList<File> list = new ArrayList<File>();
        int i = 0;
        while (i < files.length) {
            if (files[i] != null) {
                list.add(files[i]);
            }
            ++i;
        }
        return list;
    }

    public static Path getClassPath(Class<?> clazz) {
        try {
            return Paths.get(clazz.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get source of class '" + clazz.getName() + "'!", e);
        }
    }

    void log(String string) {
        this.logObj.print(string);
    }
}

