/*
 * Decompiled with CFR 0.152.
 */
package b100.asmloader.internal;

import b100.asmloader.ClassTransformer;
import b100.asmloader.internal.ASMHelper;
import b100.asmloader.internal.Log;
import b100.asmloader.internal.ModInfo;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.tree.ClassNode;

public class ASMLoaderTransformer
implements ClassFileTransformer {
    private Log logObj;
    private List<ClassTransformer> classTransformers;
    private Map<ClassTransformer, ModInfo> classTransformerToModMap;

    public ASMLoaderTransformer(List<ClassTransformer> classTransformers, Map<ClassTransformer, ModInfo> classTransformerToModMap, Log logObj) {
        this.classTransformers = classTransformers;
        this.classTransformerToModMap = classTransformerToModMap;
        this.logObj = logObj;
    }

    public byte[] transform(String className, byte[] classfileBuffer) {
        ClassNode classNode = null;
        int i = 0;
        while (i < this.classTransformers.size()) {
            ModInfo modInfo;
            ClassTransformer classTransformer = this.classTransformers.get(i);
            String modId = null;
            if (this.classTransformerToModMap != null && (modInfo = this.classTransformerToModMap.get(classTransformer)) != null) {
                modId = modInfo.modid;
            }
            if (classTransformer.accepts(className)) {
                if (modId != null) {
                    this.log("Transforming class '" + className + "' using transformer '" + classTransformer.getClass().getName() + "' provided by mod '" + modId + "'!");
                } else {
                    this.log("Transforming class '" + className + "' using transformer '" + classTransformer.getClass().getName() + "'!");
                }
                if (classNode == null) {
                    classNode = ASMHelper.getClassNode(classfileBuffer);
                }
                classTransformer.transform(className, classNode);
            }
            ++i;
        }
        if (classNode != null) {
            return ASMHelper.getBytes(classNode);
        }
        return classfileBuffer;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (className == null) {
            return classfileBuffer;
        }
        try {
            return this.transform(className, classfileBuffer);
        }
        catch (Exception e) {
            System.err.println("Error transforming class '" + className + "'!");
            e.printStackTrace();
            System.exit(1);
            throw new RuntimeException();
        }
    }

    private void log(String string) {
        this.logObj.print(string);
    }
}

