/*
 * Decompiled with CFR 0.152.
 */
package b100.asmloader.internal;

import b100.utils.interfaces.Condition;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ASMHelper {
    public static ClassNode getClassNode(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept(classNode, 0);
        return classNode;
    }

    public static byte[] getBytes(ClassNode classNode) {
        ClassWriter classWriter = new ClassWriter(2){

            @Override
            protected String getCommonSuperClass(String type1, String type2) {
                List superClasses1 = ASMHelper.getSuperClasses(type1);
                List superClasses2 = ASMHelper.getSuperClasses(type2);
                superClasses1.add(0, type1);
                superClasses2.add(0, type2);
                int i = 0;
                while (i < superClasses1.size()) {
                    int j = 0;
                    while (j < superClasses2.size()) {
                        String sup2;
                        String sup1 = (String)superClasses1.get(i);
                        if (sup1.equals(sup2 = (String)superClasses2.get(j))) {
                            return sup1;
                        }
                        ++j;
                    }
                    ++i;
                }
                System.out.println("getCommonSuperClass");
                System.out.println("TYPE1: " + type1);
                i = 1;
                while (i < superClasses1.size()) {
                    System.out.println("    extends " + (String)superClasses1.get(i));
                    ++i;
                }
                System.out.println("TYPE2: " + type2);
                i = 1;
                while (i < superClasses2.size()) {
                    System.out.println("    extends " + (String)superClasses2.get(i));
                    ++i;
                }
                throw new RuntimeException();
            }
        };
        classNode.accept(classWriter);
        return classWriter.toByteArray();
    }

    private static List<String> getSuperClasses(String className) {
        ArrayList<String> superClasses = new ArrayList<String>();
        while ((className = ASMHelper.getSuperClass(className)) != null) {
            superClasses.add(className);
        }
        return superClasses;
    }

    private static String getSuperClass(String name) {
        Class<?> cls;
        block15: {
            block14: {
                String path = String.valueOf(name) + ".class";
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                InputStream in = classLoader.getResourceAsStream(path);
                if (in != null) {
                    try {
                        ClassNode classNode = ASMHelper.getClassNode(ASMHelper.readAll(in));
                        String string = classNode.superName;
                        return string;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Loading class' " + path + "'!", e);
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                name = name.replace('/', '.');
                try {
                    cls = Class.forName(name, false, classLoader);
                    if (!cls.isInterface()) break block14;
                    return "java/lang/Object";
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Loading class '" + name + "'!", e);
                }
            }
            cls = cls.getSuperclass();
            if (cls != null) break block15;
            return null;
        }
        return cls.getName().replace('.', '/');
    }

    public static byte[] readAll(InputStream inputStream) throws IOException {
        byte[] cache;
        int read;
        int cacheSize = 4096;
        class ByteCache {
            private List<1ByteCache.CacheEntry> allBuffers = new ArrayList<1ByteCache.CacheEntry>();

            ByteCache() {
            }

            public void put(byte[] bytes, int offset, int length) {
                1ByteCache.CacheEntry cacheEntry = new 1ByteCache.CacheEntry();
                cacheEntry.bytes = bytes;
                cacheEntry.length = length;
                cacheEntry.offset = offset;
                this.allBuffers.add(cacheEntry);
            }

            public byte[] getAll() {
                int totalSize = 0;
                int buffers = this.allBuffers.size();
                int i = 0;
                while (i < buffers) {
                    totalSize += this.allBuffers.get((int)i).length;
                    ++i;
                }
                byte[] allBytes = new byte[totalSize];
                int offset = 0;
                int i2 = 0;
                while (i2 < buffers) {
                    1ByteCache.CacheEntry cacheEntry = this.allBuffers.get(i2);
                    byte[] bytes = cacheEntry.bytes;
                    int j = 0;
                    while (j < cacheEntry.length) {
                        allBytes[offset + j] = bytes[cacheEntry.offset + j];
                        ++j;
                    }
                    offset += cacheEntry.length;
                    ++i2;
                }
                return allBytes;
            }

            class 1ByteCache.CacheEntry {
                public byte[] bytes;
                public int offset;
                public int length;

                1ByteCache.CacheEntry() {
                }
            }
        }
        ByteCache byteCache = new ByteCache();
        while ((read = inputStream.read(cache = new byte[4096], 0, cache.length)) != -1) {
            byteCache.put(cache, 0, read);
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byteCache.getAll();
    }

    public static AbstractInsnNode findInstruction(AbstractInsnNode startInstruction, boolean backwards, Condition<AbstractInsnNode> condition) {
        AbstractInsnNode instruction = startInstruction;
        while (instruction != null) {
            if (condition.isTrue(instruction)) {
                return instruction;
            }
            instruction = backwards ? instruction.getPrevious() : instruction.getNext();
        }
        return null;
    }

    public static MethodNode findMethod(ClassNode classNode, String name, String desc) {
        ArrayList<MethodNode> foundMethods = new ArrayList<MethodNode>();
        for (MethodNode methodNode : classNode.methods) {
            if (name != null && !methodNode.name.equals(name) || desc != null && !methodNode.desc.equals(desc)) continue;
            foundMethods.add(methodNode);
        }
        if (foundMethods.size() != 1) {
            StringBuilder msg = new StringBuilder();
            msg.append("\n\n");
            if (foundMethods.size() < 1) {
                msg.append("Found no methods with name '" + name + "' and descriptor '" + desc + "' in class '" + classNode.name + "'!\n");
            } else {
                msg.append("Found more than one method matching name '" + name + "' and descriptor '" + desc + "' in class '" + classNode.name + "'!\n");
            }
            msg.append('\n');
            msg.append("All methods in class '" + classNode.name + "': \n");
            for (MethodNode method : classNode.methods) {
                msg.append("    ").append(method.name).append(method.desc).append('\n');
            }
            throw new RuntimeException(msg.toString());
        }
        return (MethodNode)foundMethods.get(0);
    }

    public static boolean methodInsn(AbstractInsnNode node, String owner, String name, String desc) {
        if (node instanceof MethodInsnNode) {
            MethodInsnNode node1 = (MethodInsnNode)node;
            return node1.owner.equals(owner) && node1.name.equals(name) && node1.desc.equals(desc);
        }
        return false;
    }
}

