/*
 * Decompiled with CFR 0.152.
 */
package b100.asmloader.gui.utils;

import b100.asmloader.internal.ModInfo;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ModList
implements Iterable<ModInfo>,
KeyListener {
    private List<ModInfo> entries = new ArrayList<ModInfo>();
    private List<ListDataListener> listDataListeners = new ArrayList<ListDataListener>();
    public JList<ModInfo> list = new JList<ModInfo>(new ListModelImpl());

    public ModList() {
        this.list.addKeyListener(this);
    }

    public int getSize() {
        return this.entries.size();
    }

    public ModInfo get(int i) {
        return this.entries.get(i);
    }

    public void add(ModInfo modInfo) {
        this.entries.add(modInfo);
        this.onUpdate();
    }

    public void clear() {
        this.entries.clear();
        this.onUpdate();
    }

    public void onUpdate() {
        ListDataEvent listDataEvent = new ListDataEvent(this.list, 0, 0, 0);
        for (ListDataListener listDataListener : this.listDataListeners) {
            listDataListener.contentsChanged(listDataEvent);
        }
    }

    @Override
    public Iterator<ModInfo> iterator() {
        return new IteratorImpl();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 127 && this.list.getSelectedIndex() != -1) {
            this.entries.remove(this.list.getSelectedIndex());
            this.onUpdate();
            this.list.clearSelection();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    class IteratorImpl
    implements Iterator<ModInfo> {
        private int pos;

        IteratorImpl() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < ModList.this.entries.size();
        }

        @Override
        public ModInfo next() {
            return (ModInfo)ModList.this.entries.get(this.pos++);
        }
    }

    class ListModelImpl
    implements ListModel<ModInfo> {
        ListModelImpl() {
        }

        @Override
        public int getSize() {
            return ModList.this.entries.size();
        }

        @Override
        public ModInfo getElementAt(int index) {
            return (ModInfo)ModList.this.entries.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            ModList.this.listDataListeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            ModList.this.listDataListeners.remove(l);
        }
    }
}

