/*
 * Decompiled with CFR 0.152.
 */
package b100.asmloader.gui.utils;

import b100.asmloader.gui.utils.FileDropHandler;
import b100.asmloader.gui.utils.FileDropListener;
import b100.asmloader.gui.utils.FileEventListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;

public class FileTextField
extends JTextField
implements FileDropListener {
    private List<FileEventListener> fileEventListeners = new ArrayList<FileEventListener>();

    public FileTextField() {
        FileDropHandler.addFileDropListener(this, this);
    }

    public FileTextField(int size) {
        super(size);
        FileDropHandler.addFileDropListener(this, this);
    }

    @Override
    public void onFileDrop(List<File> files) {
        if (files.size() > 0) {
            File file = files.get(0);
            this.setFile(file);
            int i = 0;
            while (i < this.fileEventListeners.size()) {
                this.fileEventListeners.get(i).onFileEvent(this, file);
                ++i;
            }
        }
    }

    public void setFile(File file) {
        String runDirectory;
        String filePath = file.getAbsolutePath();
        if (filePath.startsWith(String.valueOf(runDirectory = new File("").getAbsoluteFile().getAbsolutePath()) + "/")) {
            filePath = filePath.substring(runDirectory.length());
        }
        this.setText(filePath);
    }

    public void addFileEventListener(FileEventListener fileEventListener) {
        this.fileEventListeners.add(fileEventListener);
    }

    public void removeFileEventListener(FileEventListener fileEventListener) {
        this.fileEventListeners.remove(fileEventListener);
    }
}

