/*
 * Decompiled with CFR 0.152.
 */
package b100.asmloader.gui.utils;

import b100.asmloader.gui.utils.FileDropListener;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.List;

public class FileDropHandler
implements DropTargetListener {
    private static List<FileDropHandler> fileDropHandlers = new ArrayList<FileDropHandler>();
    public final DropTarget dropTarget;
    public final FileDropListener fileDropListener;

    public static void addFileDropListener(Component component, FileDropListener fileDropListener) {
        fileDropHandlers.add(new FileDropHandler(component, fileDropListener));
    }

    private FileDropHandler(Component comp, FileDropListener fileDropListener) {
        this.dropTarget = new DropTarget(comp, this);
        this.fileDropListener = fileDropListener;
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        try {
            e.acceptDrop(1);
            List files = (List)e.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            if (this.fileDropListener != null && files != null) {
                this.fileDropListener.onFileDrop(files);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }
}

