/*
 * Decompiled with CFR 0.152.
 */
package b100.asmloader.gui;

import b100.asmloader.exporter.ModExporter;
import b100.asmloader.gui.ASMLoaderGUI;
import b100.asmloader.gui.utils.FileDropHandler;
import b100.asmloader.gui.utils.FileDropListener;
import b100.asmloader.gui.utils.FileTextField;
import b100.asmloader.gui.utils.GridPanel;
import b100.asmloader.gui.utils.ModList;
import b100.asmloader.internal.LoaderUtils;
import b100.asmloader.internal.Log;
import b100.asmloader.internal.ModInfo;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class ModExporterGUI
extends GridPanel
implements ActionListener,
FileDropListener,
Log,
Runnable {
    public ASMLoaderGUI asmLoaderGUI;
    public JTextField minecraftJarTextField;
    public JTextField outputJarTextField;
    public ModList modList;
    public JCheckBox includeOverridesCheckbox;
    public JCheckBox includeModFilesCheckbox;
    public JButton exportButton;
    public LoaderUtils loaderUtils = new LoaderUtils(this);

    public ModExporterGUI(ASMLoaderGUI asmLoaderGUI) {
        this.asmLoaderGUI = asmLoaderGUI;
        this.getGridBagConstraints().insets = new Insets(4, 4, 4, 4);
        this.defaultWeightX = 1.0;
        this.defaultWeightY = 0.0;
        this.minecraftJarTextField = new FileTextField();
        this.outputJarTextField = new FileTextField();
        this.modList = new ModList();
        FileDropHandler.addFileDropListener(this.modList.list, this);
        this.includeOverridesCheckbox = new JCheckBox("Overrides");
        this.includeOverridesCheckbox.setSelected(true);
        this.includeModFilesCheckbox = new JCheckBox("Mod Files");
        this.includeModFilesCheckbox.setSelected(true);
        this.exportButton = new JButton("Export");
        this.exportButton.addActionListener(this);
        GridPanel filesPanel = new GridPanel(4, 0.0, 0.0);
        filesPanel.setBorder(new TitledBorder("Files"));
        filesPanel.add(new JLabel("Minecraft Jar"), 0, 0, 0.0, 0.0);
        filesPanel.add(new JLabel("Output Jar"), 0, 1, 0.0, 0.0);
        filesPanel.add(this.minecraftJarTextField, 1, 0, 1.0, 0.0);
        filesPanel.add(this.outputJarTextField, 1, 1, 1.0, 0.0);
        GridPanel modsPanel = new GridPanel(4, 1.0, 1.0);
        modsPanel.setBorder(new TitledBorder("Mods"));
        modsPanel.add((Component)this.modList.list, 0, 0);
        GridPanel includePanel = new GridPanel(0, 1.0, 1.0);
        includePanel.setBorder(new TitledBorder("Include"));
        includePanel.add((Component)this.includeOverridesCheckbox, 0, 0);
        includePanel.add((Component)this.includeModFilesCheckbox, 1, 0);
        this.add((Component)filesPanel, 0, 0);
        this.add(modsPanel, 0, 1, 1.0, 1.0);
        this.add((Component)includePanel, 0, 2);
        this.add((Component)this.exportButton, 0, 3);
    }

    @Override
    public void onFileDrop(List<File> files) {
        new Thread(() -> {
            if (files.size() == 0) {
                return;
            }
            if (files.size() == 1) {
                File file = (File)files.get(0);
                if (file.isDirectory() && !this.loaderUtils.peepModJson(file)) {
                    File[] filesInDirectory = file.listFiles();
                    if (filesInDirectory != null && filesInDirectory.length > 0) {
                        this.addMultipleMods(this.loaderUtils.toList(filesInDirectory));
                    }
                    return;
                }
                this.addMod(file);
            } else {
                this.addMultipleMods(files);
            }
        }).start();
    }

    protected void addMultipleMods(List<File> files) {
        ArrayList<File> erroredFiles = new ArrayList<File>();
        for (File file : files) {
            ModInfo modInfo;
            if (!this.loaderUtils.peepModJson(file)) continue;
            try {
                modInfo = this.loaderUtils.readModInfo(file, false);
            }
            catch (Exception e) {
                erroredFiles.add(file);
                System.err.println("Error while reading mod '" + file.getName() + "'!");
                e.printStackTrace();
                continue;
            }
            this.modList.add(modInfo);
        }
        if (erroredFiles.size() == 1) {
            File file;
            file = (File)erroredFiles.get(0);
            JOptionPane.showMessageDialog(this, "Error while reading mod '" + file.getName() + "'! Check the log for more information.", "Error", 0);
        } else if (erroredFiles.size() > 1) {
            JOptionPane.showMessageDialog(this, String.valueOf(erroredFiles.size()) + " mods could not be added! Check the log for more information.", "Error", 0);
        }
        this.modList.onUpdate();
    }

    protected void addMod(File file) {
        ModInfo modInfo;
        if (!this.loaderUtils.peepModJson(file)) {
            JOptionPane.showMessageDialog(this, "File '" + file.getName() + "' does not contain a mod!", "Error", 0);
            return;
        }
        try {
            modInfo = this.loaderUtils.readModInfo(file, false);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error while reading file '" + file.getName() + "'! Check the log for more information.", "Error", 0);
            System.err.println("Error while reading mod '" + file.getName() + "'!");
            e.printStackTrace();
            return;
        }
        this.modList.add(modInfo);
        this.modList.onUpdate();
    }

    @Override
    public void run() {
        this.exportButton.setEnabled(false);
        this.asmLoaderGUI.log.clear();
        try {
            File minecraftJarFile;
            ModExporter exporter = new ModExporter();
            if (this.minecraftJarTextField.getText().length() > 0) {
                minecraftJarFile = new File(this.minecraftJarTextField.getText());
                if (!minecraftJarFile.exists()) {
                    JOptionPane.showMessageDialog(this, "File '" + minecraftJarFile.getAbsolutePath() + "' does not exist!", "Failure", 0);
                    return;
                }
            } else {
                JOptionPane.showMessageDialog(this, "No Minecraft Jar provided!", "Failure", 0);
                return;
            }
            exporter.minecraftJar = minecraftJarFile;
            File outputJarFile = this.outputJarTextField.getText().length() > 0 ? new File(this.outputJarTextField.getText()) : new File("asmloader-export.jar");
            if (outputJarFile.isDirectory()) {
                JOptionPane.showMessageDialog(this, "Output Jar File is a directory!", "Failure", 0);
                return;
            }
            exporter.outputFile = outputJarFile;
            exporter.includeModFiles = this.includeModFilesCheckbox.isSelected();
            exporter.includeOverrides = this.includeOverridesCheckbox.isSelected();
            if (this.modList.getSize() == 0) {
                JOptionPane.showMessageDialog(this, "No Mods provided!", "Failure", 0);
                return;
            }
            if (outputJarFile.exists() && JOptionPane.showConfirmDialog(this, "Output file '" + outputJarFile.getAbsolutePath() + "' already exists! Do you want to override it?", "", 0, 2) != 0) {
                return;
            }
            int i = 0;
            while (i < this.modList.getSize()) {
                ModInfo modInfo = this.modList.get(i);
                exporter.modFiles.add(modInfo.file);
                ++i;
            }
            this.asmLoaderGUI.showLog();
            try {
                exporter.run();
                JOptionPane.showMessageDialog(this, "Jar file has been saved to '" + exporter.outputFile.getAbsolutePath() + "'!", "Success", 1);
            }
            catch (ModExporter.ModExporterException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Failure", 0);
                e.printStackTrace();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "An Unexpected Error occurred. Please check the log for more information.", "Failure", 0);
                e.printStackTrace();
            }
        }
        finally {
            this.exportButton.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.exportButton) {
            new Thread(this).start();
        }
    }

    @Override
    public void print(String string) {
        System.out.print("[Mod Exporter] " + string + "\n");
    }
}

