/*
 * Decompiled with CFR 0.152.
 */
package b100.asmloader.exporter;

import b100.asmloader.ClassTransformer;
import b100.asmloader.internal.ASMHelper;
import b100.asmloader.internal.LoaderUtils;
import b100.asmloader.internal.Log;
import b100.asmloader.internal.ModInfo;
import b100.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.tree.ClassNode;

public class ModExporter
implements Log,
Runnable {
    public final List<File> modFiles = new ArrayList<File>();
    public File minecraftJar;
    public File outputFile;
    public boolean includeOverrides = true;
    public boolean includeModFiles = true;
    protected List<ModInfo> modInfos = new ArrayList<ModInfo>();
    protected List<ClassTransformer> classTransformers = new ArrayList<ClassTransformer>();
    protected Map<String, ClassNode> allClasses = new HashMap<String, ClassNode>();
    protected Set<String> modifiedClasses = new HashSet<String>();
    protected LoaderUtils loaderUtils = new LoaderUtils(this);
    protected ClassLoader classLoader;

    @Override
    public void run() {
        if (this.outputFile == null) {
            this.outputFile = new File("asmloader-export.jar");
        }
        this.loadMods();
        if (this.modInfos.size() == 1) {
            this.print("Loaded 1 mod!");
        } else {
            this.print("Loaded " + this.modInfos.size() + " mods!");
        }
        this.createClassLoader();
        this.loadClassTransformers();
        if (this.classTransformers.size() == 1) {
            this.print("Loaded 1 Class Transformer!");
        } else {
            this.print("Loaded " + this.classTransformers.size() + " Class Transformers!");
        }
        this.loadMinecraftJarClasses();
        if (this.allClasses.size() == 1) {
            this.print("Loaded 1 Class!");
        } else {
            this.print("Loaded " + this.allClasses.size() + " Classes!");
        }
        this.transformMinecraftClasses();
        this.export();
        this.print("Done!");
    }

    protected void loadMods() {
        int i = 0;
        while (i < this.modFiles.size()) {
            ModInfo modInfo;
            File modFile = this.modFiles.get(i);
            try {
                modInfo = this.loaderUtils.readModInfo(modFile, false);
            }
            catch (Exception e) {
                throw new ModExporterException("Could not read mod: '" + modFile.getAbsolutePath() + "'!", e);
            }
            this.print(String.valueOf(modFile.getName()) + ": " + modInfo.modid + ", " + modInfo.transformerClasses.size() + " transformers");
            this.modInfos.add(modInfo);
            ++i;
        }
    }

    protected void createClassLoader() {
        try {
            URL[] urls = new URL[this.modInfos.size()];
            int i = 0;
            while (i < this.modInfos.size()) {
                ModInfo mod = this.modInfos.get(i);
                URL url = mod.file.isFile() ? new URL("jar:file:" + mod.file.getAbsolutePath() + "!/") : mod.file.toURI().toURL();
                urls[i] = url;
                ++i;
            }
            this.classLoader = new URLClassLoader(urls);
        }
        catch (Exception e) {
            throw new RuntimeException("Creating ClassLoader", e);
        }
    }

    protected void loadClassTransformers() {
        int i = 0;
        while (i < this.modInfos.size()) {
            this.loaderUtils.loadClassTransformers(this.classLoader, this.modInfos.get(i), this.classTransformers);
            ++i;
        }
    }

    protected void loadMinecraftJarClasses() {
        ZipFile zipFile;
        try {
            zipFile = new ZipFile(this.minecraftJar);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open minecraft jar! ", e);
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            byte[] bytes;
            ZipEntry entry = enumeration.nextElement();
            String name = entry.getName();
            if (!name.endsWith(".class")) continue;
            String className = name;
            className = className.substring(0, className.length() - 6);
            try {
                InputStream in = zipFile.getInputStream(entry);
                bytes = ASMHelper.readAll(in);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not read class: '" + className + "'!", e);
            }
            ClassNode classNode = ASMHelper.getClassNode(bytes);
            this.allClasses.put(className, classNode);
        }
        try {
            zipFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void transformMinecraftClasses() {
        for (String className : this.allClasses.keySet()) {
            ClassNode classNode = this.allClasses.get(className);
            boolean modified = false;
            for (ClassTransformer classTransformer : this.classTransformers) {
                if (!classTransformer.accepts(className)) continue;
                this.print("Transforming " + className);
                classTransformer.transform(className, classNode);
                modified = true;
            }
            if (!modified) continue;
            this.modifiedClasses.add(className);
        }
    }

    protected void export() {
        try {
            ZipOutputStream zipOutputStream;
            FileOutputStream fileOutputStream;
            FileUtils.createFolderForFile(this.outputFile);
            try {
                fileOutputStream = new FileOutputStream(this.outputFile);
                zipOutputStream = new ZipOutputStream(fileOutputStream);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not open output file: " + this.outputFile.getAbsolutePath(), e);
            }
            HashSet<String> writtenEntries = new HashSet<String>();
            if (this.includeOverrides) {
                for (String className : this.modifiedClasses) {
                    String classPath = String.valueOf(className) + ".class";
                    ClassNode classNode = this.allClasses.get(className);
                    byte[] bytes = ASMHelper.getBytes(classNode);
                    ModExporter.writeToZip(zipOutputStream, classPath, bytes);
                    writtenEntries.add(classPath);
                }
            }
            if (this.includeModFiles) {
                for (ModInfo mod : this.modInfos) {
                    ZipFile zipFile = null;
                    ArrayList<String> allResources = new ArrayList<String>();
                    if (mod.file.isFile()) {
                        zipFile = new ZipFile(mod.file);
                        Enumeration<? extends ZipEntry> entries = zipFile.entries();
                        while (entries.hasMoreElements()) {
                            ZipEntry entry = entries.nextElement();
                            if (entry.getName().endsWith("/")) continue;
                            allResources.add(entry.getName());
                        }
                    } else {
                        int pathLength = mod.file.getAbsolutePath().length();
                        List<File> allFiles = FileUtils.getAllFiles(mod.file);
                        for (File file : allFiles) {
                            allResources.add(file.getAbsolutePath().substring(pathLength + 1).replace('\\', '/'));
                        }
                    }
                    for (String entry : allResources) {
                        this.print("Copy Resource: '" + entry + "'");
                        if (entry.equals("asmloader.mod.json")) continue;
                        if (writtenEntries.contains(entry)) {
                            this.print("Duplicate Resource: '" + entry + "'!");
                            continue;
                        }
                        InputStream in = null;
                        in = zipFile != null ? zipFile.getInputStream(zipFile.getEntry(entry)) : new FileInputStream(new File(mod.file, entry));
                        try {
                            byte[] data = ASMHelper.readAll(in);
                            zipOutputStream.putNextEntry(new ZipEntry(entry));
                            zipOutputStream.write(data);
                            writtenEntries.add(entry);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Error writing to zip file!", e);
                        }
                        try {
                            in.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (zipFile == null) continue;
                    try {
                        zipFile.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            try {
                zipOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            throw new RuntimeException("Exporting", e);
        }
    }

    @Override
    public void print(String string) {
        System.out.print("[Mod Exporter] " + string + "\n");
    }

    private static void writeToZip(ZipOutputStream zipOutputStream, String entry, byte[] bytes) {
        try {
            zipOutputStream.putNextEntry(new ZipEntry(entry));
            zipOutputStream.write(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException("Error to zip file: " + entry, e);
        }
    }

    public static class ModExporterException
    extends RuntimeException {
        public ModExporterException(String message) {
            super(message);
        }

        public ModExporterException(String message, Throwable throwable) {
            super(message, throwable);
        }
    }
}

