/*
 * Decompiled with CFR 0.152.
 */
package b100.asmloader.dev;

import b100.asmloader.ClassTransformer;
import b100.asmloader.dev.SingleRemapper;
import b100.asmloader.internal.ASMHelper;
import b100.asmloader.internal.LoaderUtils;
import b100.asmloader.internal.LoaderUtilsFabric;
import b100.asmloader.internal.Log;
import b100.asmloader.internal.ModInfo;
import b100.json.element.JsonArray;
import b100.json.element.JsonObject;
import b100.json.element.JsonString;
import b100.utils.FileUtils;
import b100.utils.StreamUtils;
import b100.utils.StringUtils;
import b100.utils.interfaces.Condition;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

public class FabricModPatcher
implements Log {
    public File minecraftJar;
    public File modFile;
    public File outputFile;
    private File workDir;
    private String modid;
    private String version;
    protected LoaderUtils loaderUtils = new LoaderUtilsFabric(this);
    private List<ClassTransformer> classTransformers;
    private Set<String> mixinClassList;

    public static void patchAllModsInDirectory(File dir, File minecraftJar) {
        FabricModPatcher fabricModPatcher = new FabricModPatcher();
        fabricModPatcher.minecraftJar = minecraftJar;
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (fabricModPatcher.loaderUtils.peepModJson(file)) {
                fabricModPatcher.modFile = file;
                fabricModPatcher.outputFile = null;
                try {
                    fabricModPatcher.run();
                }
                catch (Exception e) {
                    System.err.println("Could not patch mod: '" + file.getAbsolutePath() + "'!");
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public void run() {
        this.workDir = this.createEmptyDirectory(new File("temp"));
        if (this.outputFile == null) {
            this.outputFile = new File(this.getNewName(this.modFile.getName()));
        }
        this.copyASMLoaderClasses();
        this.print("Unpack " + this.modFile.getName() + " into " + this.workDir.getName());
        this.unpackZipFile(this.modFile, this.workDir, null);
        this.print("Read Mod Info");
        this.readModInfo();
        this.print("Mod ID: '" + this.modid + "'");
        this.print("Mod Version: " + this.version);
        this.print("Class Transformers: " + this.classTransformers.size());
        this.print("Create Fabric Jsons");
        this.createFabricModJson();
        this.createMixinClassList();
        this.addFabricClasses();
        this.print("Pack Mod: " + this.outputFile.getName());
        this.packZipFile(this.outputFile, this.workDir);
    }

    public void copyASMLoaderClasses() {
        File file = LoaderUtils.getClassPath(FabricModPatcher.class).toFile();
        Condition<String> shouldCopy = entry -> !entry.startsWith("b100/asmloader/") || entry.equals("b100/asmloader/ClassTransformer.class");
        if (file.isDirectory()) {
            int pathLength = file.getAbsolutePath().length();
            List<File> allFiles = FileUtils.getAllFiles(new File(file, "b100"));
            int i = 0;
            while (i < allFiles.size()) {
                File oldFile = allFiles.get(i);
                String entry2 = oldFile.getAbsolutePath().substring(pathLength + 1).replace('\\', '/');
                if (shouldCopy.isTrue(entry2)) {
                    File newFile = new File(this.workDir, entry2);
                    FileUtils.copy(oldFile, newFile);
                }
                ++i;
            }
        } else {
            this.unpackZipFile(file, this.workDir, shouldCopy);
        }
    }

    public void readModInfo() {
        URLClassLoader classLoader;
        ModInfo modInfo = this.loaderUtils.readModInfo(this.modFile, false);
        this.modid = modInfo.modid;
        this.version = modInfo.version != null ? modInfo.version : "UNKNOWN";
        try {
            classLoader = new URLClassLoader(new URL[]{this.modFile.toURI().toURL()});
        }
        catch (Exception e) {
            throw new RuntimeException("Creating URL ClassLoader", e);
        }
        this.classTransformers = new ArrayList<ClassTransformer>();
        this.loaderUtils.loadClassTransformers(classLoader, modInfo, this.classTransformers);
    }

    public void createFabricModJson() {
        if (this.modid == null) {
            throw new NullPointerException("Mod ID is null!");
        }
        File fabricModJsonFile = new File(this.workDir, "fabric.mod.json");
        JsonObject fabricModJson = new JsonObject();
        fabricModJson.set("schemaVersion", 1);
        fabricModJson.set("id", this.modid);
        fabricModJson.set("version", this.version);
        fabricModJson.set("environment", "*");
        fabricModJson.set("mixins", new JsonArray(1).set(0, new JsonString(String.valueOf(this.modid) + ".mixins.json")));
        StringUtils.saveStringToFile(fabricModJsonFile, fabricModJson.toString());
        File mixinsJsonFile = new File(this.workDir, String.valueOf(this.modid) + ".mixins.json");
        JsonObject mixinsJson = new JsonObject();
        mixinsJson.set("required", "true");
        mixinsJson.set("package", "asmcompat." + this.modid + ".mixin");
        mixinsJson.set("plugin", "asmcompat." + this.modid + ".Plugin");
        mixinsJson.set("mixins", new JsonArray(0));
        mixinsJson.set("injectors", new JsonObject().set("defaultRequire", 1));
        StringUtils.saveStringToFile(mixinsJsonFile, mixinsJson.toString());
    }

    public void createMixinClassList() {
        HashSet<String> allMinecraftJarClasses = new HashSet<String>();
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(this.minecraftJar);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    String entryName = entries.nextElement().getName();
                    if (!entryName.endsWith(".class") || allMinecraftJarClasses.contains(entryName = entryName.substring(0, entryName.length() - 6))) continue;
                    allMinecraftJarClasses.add(entryName);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Reading minecraft jar '" + this.minecraftJar.getAbsolutePath() + "'", e);
            }
        }
        finally {
            try {
                zipFile.close();
            }
            catch (Exception exception) {}
        }
        this.mixinClassList = new HashSet<String>();
        for (String className : allMinecraftJarClasses) {
            int i = 0;
            while (i < this.classTransformers.size()) {
                ClassTransformer classTransformer = this.classTransformers.get(i);
                if (classTransformer.accepts(className)) {
                    this.mixinClassList.add(className);
                }
                ++i;
            }
        }
    }

    public void addFabricClasses() {
        File fabricZipFile = new File(this.workDir, "fabric.zip");
        this.extractResource("/fabric.zip", fabricZipFile);
        String[][] extractList = new String[][]{{"asmcompat/" + this.modid + "/mixin", "Dummy"}, {"asmcompat/" + this.modid, "Plugin"}};
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(fabricZipFile);
                int i = 0;
                while (i < extractList.length) {
                    String packageName = extractList[i][0];
                    String className = extractList[i][1];
                    ZipEntry entry = zipFile.getEntry(String.valueOf(className) + ".class");
                    File file = new File(this.workDir, String.valueOf(packageName) + "/" + className + ".class");
                    File parent = file.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    InputStream in = null;
                    OutputStream out = null;
                    try {
                        try {
                            in = zipFile.getInputStream(entry);
                            byte[] bytes = ASMHelper.readAll(in);
                            ClassNode classNode = ASMHelper.getClassNode(bytes);
                            classNode = this.renameClass(classNode, String.valueOf(packageName) + "/" + className);
                            List<AnnotationNode> annotations = classNode.invisibleAnnotations;
                            if (annotations != null && annotations.size() > 0 && annotations.get((int)0).desc.equals("Lorg/spongepowered/asm/mixin/Mixin;")) {
                                if (this.mixinClassList == null) {
                                    throw new NullPointerException();
                                }
                                ArrayList<String> list = new ArrayList<String>(this.mixinClassList);
                                list.sort(String.CASE_INSENSITIVE_ORDER);
                                annotations.get((int)0).values.set(1, list);
                            }
                            bytes = ASMHelper.getBytes(classNode);
                            out = new FileOutputStream(file);
                            out.write(bytes, 0, bytes.length);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Extracting Fabric Classes", e);
                        }
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                        try {
                            out.close();
                        }
                        catch (Exception exception) {}
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Extracting file: '" + fabricZipFile.getAbsolutePath() + "'", e);
            }
        }
        finally {
            try {
                zipFile.close();
            }
            catch (Exception exception) {}
        }
        fabricZipFile.delete();
    }

    public ClassNode renameClass(ClassNode classNode, String newName) {
        ClassNode newNode = new ClassNode();
        SingleRemapper remapper = new SingleRemapper(classNode.name, newName);
        ClassRemapper classRemapper = new ClassRemapper(newNode, remapper);
        classNode.accept(classRemapper);
        return newNode;
    }

    public File createEmptyDirectory(File file) {
        if (file.exists()) {
            if (!file.isDirectory()) {
                file.delete();
                file.mkdirs();
            } else {
                this.deleteAllFilesInDirectory(file);
            }
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public void deleteAllFilesInDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                this.deleteAllFilesInDirectory(file);
            }
            file.delete();
            ++i;
        }
    }

    public void unpackZipFile(File zip, File target, Condition<String> shouldCopy) {
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(zip);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String entryName = entry.toString();
                    if (entryName.endsWith("/") || shouldCopy != null && !shouldCopy.isTrue(entryName)) continue;
                    File file = new File(target, entryName);
                    File parent = file.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    try {
                        InputStream in = zipFile.getInputStream(entry);
                        FileOutputStream out = new FileOutputStream(file);
                        this.transferDataAndClose(in, out);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unpacking Zip Entry '" + entry + "'!", e);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unpacking Zip File '" + zip.getAbsolutePath() + "' into '" + target.getAbsolutePath() + "'!", e);
            }
        }
        finally {
            try {
                zipFile.close();
            }
            catch (Exception exception) {}
        }
    }

    public void packZipFile(File zip, File directory) {
        ZipOutputStream out = null;
        try {
            try {
                String dirPath = directory.getAbsolutePath();
                List<File> allFiles = FileUtils.getAllFiles(directory);
                int i = 0;
                while (i < allFiles.size()) {
                    ++i;
                }
                out = new ZipOutputStream(new FileOutputStream(zip));
                i = 0;
                while (i < allFiles.size()) {
                    File file = allFiles.get(i);
                    String path = file.getAbsolutePath();
                    if (!path.startsWith(dirPath)) {
                        throw new RuntimeException("Invalid Path: '" + path + "'!");
                    }
                    String entryName = path.substring(dirPath.length() + 1).replace('\\', '/');
                    ZipEntry entry = new ZipEntry(entryName);
                    out.putNextEntry(entry);
                    FileInputStream in = null;
                    try {
                        try {
                            in = new FileInputStream(file);
                            StreamUtils.transferData(in, out);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Packing file '" + file.getAbsolutePath() + "'", e);
                        }
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Pack directory '" + directory.getAbsolutePath() + "' into zip file '" + zip.getAbsolutePath() + "'!", e);
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public void extractResource(String resourcePath, File file) {
        try {
            InputStream in = FabricModPatcher.class.getResourceAsStream(resourcePath);
            FileOutputStream out = new FileOutputStream(file);
            this.transferDataAndClose(in, out);
        }
        catch (Exception e) {
            throw new RuntimeException("Extracting resource '" + resourcePath + "' to '" + file.getAbsolutePath() + "'", e);
        }
    }

    public void transferDataAndClose(InputStream in, OutputStream out) {
        try {
            try {
                StreamUtils.transferData(in, out);
            }
            catch (Exception e) {
                throw new RuntimeException("Transfering Data!", e);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public String getNewName(String name) {
        int asmloaderIndex = name.toLowerCase().indexOf("asmloader");
        int extensionPointIndex = name.lastIndexOf(46);
        if (extensionPointIndex == -1 || name.lastIndexOf(32) > extensionPointIndex) {
            throw new RuntimeException("Invalid file name!");
        }
        name = String.valueOf(name.substring(0, extensionPointIndex)) + ".jar";
        name = asmloaderIndex != -1 ? String.valueOf(name.substring(0, asmloaderIndex)) + "UNIVERSAL" + name.substring(asmloaderIndex + 9) : String.valueOf(name.substring(0, extensionPointIndex)) + "-UNIVERSAL" + name.substring(extensionPointIndex);
        return name;
    }

    @Override
    public void print(String string) {
        System.out.print("[FabricModPatcher] " + string + "\n");
    }
}

