/*
 * Decompiled with CFR 0.152.
 */
package b100.asmloader.core;

import b100.asmloader.ClassTransformer;
import b100.asmloader.core.ASMLoaderCore;
import b100.asmloader.internal.ASMLoader;
import b100.asmloader.internal.ASMLoaderTransformer;
import b100.asmloader.internal.LoaderUtils;
import b100.asmloader.internal.Log;
import b100.asmloader.internal.ModInfo;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;

public class LoaderCoreDefault
extends ASMLoaderCore
implements Log {
    public File runDirectory = new File("").getAbsoluteFile();
    public File modsFolder = new File(this.runDirectory, "mods");
    public List<File> modFilesOnClassPath;
    public List<File> modFilesInModsFolder;
    public List<File> allModFiles = new ArrayList<File>();
    public List<ModInfo> modInfos = new ArrayList<ModInfo>();
    public Map<ClassTransformer, ModInfo> classTransformerToModMap = new HashMap<ClassTransformer, ModInfo>();
    public List<ClassTransformer> classTransformers = new ArrayList<ClassTransformer>();
    public LoaderUtils loaderUtils = new LoaderUtils(this);

    @Override
    public void preMain(Instrumentation instrumentation) {
        this.findModFilesAndLoadModInfos();
        this.addModFilesToSystemClassLoader(instrumentation);
        this.loadClassTransformers(this.getClass().getClassLoader());
        instrumentation.addTransformer(new ASMLoaderTransformer(this.classTransformers, this.classTransformerToModMap, this));
    }

    public void findModFilesAndLoadModInfos() {
        this.print("Run Directory: " + this.runDirectory.getAbsolutePath());
        if (!this.modsFolder.exists()) {
            this.modsFolder.mkdirs();
        }
        this.modFilesOnClassPath = this.loaderUtils.findAllModFilesOnClassPath();
        this.modFilesInModsFolder = this.loaderUtils.findAllModFilesInDirectory(this.modsFolder);
        this.allModFiles.addAll(this.modFilesOnClassPath);
        this.allModFiles.addAll(this.modFilesInModsFolder);
        this.loaderUtils.printModFiles(this.allModFiles);
        for (File modFile : this.modFilesOnClassPath) {
            this.modInfos.add(this.loaderUtils.readModInfo(modFile, true));
        }
        for (File modFile : this.modFilesInModsFolder) {
            this.modInfos.add(this.loaderUtils.readModInfo(modFile, false));
        }
        this.loaderUtils.checkModSet(this.modInfos);
    }

    public void addModFilesToSystemClassLoader(Instrumentation instrumentation) {
        for (File modFile : this.modFilesInModsFolder) {
            ZipFile jarFile = null;
            try {
                try {
                    jarFile = new JarFile(modFile);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read jar file: '" + modFile.getAbsolutePath() + "'!", e);
                }
                try {
                    instrumentation.appendToSystemClassLoaderSearch((JarFile)jarFile);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not add jar file to class path: '" + modFile.getAbsolutePath() + "'!", e);
                }
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void loadClassTransformers(ClassLoader classLoader) {
        for (ModInfo modInfo : this.modInfos) {
            ArrayList<ClassTransformer> thisModsClassTransformers = new ArrayList<ClassTransformer>();
            this.loaderUtils.loadClassTransformers(classLoader, modInfo, thisModsClassTransformers);
            for (ClassTransformer classTransformer : thisModsClassTransformers) {
                this.classTransformerToModMap.put(classTransformer, modInfo);
            }
            this.classTransformers.addAll(thisModsClassTransformers);
        }
        this.loaderUtils.printClassTransformers(this.classTransformers, this.classTransformerToModMap);
    }

    @Override
    public void print(String string) {
        ASMLoader.log(string);
    }
}

