/*
 * Decompiled with CFR 0.152.
 */
package fiveavian.proxvc.vc.client;

import fiveavian.proxvc.ProxVCClient;
import fiveavian.proxvc.util.BufferAES;
import fiveavian.proxvc.util.DatagramPacketWrapper;
import fiveavian.proxvc.vc.StreamingAudioSource;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Map;
import net.minecraft.core.util.helper.AES;
import org.lwjgl.BufferUtils;

public class VCOutputClient
implements Runnable {
    private final ProxVCClient vcClient;
    private final DatagramSocket socket;
    private final DatagramPacketWrapper packet;
    private final Map<Integer, StreamingAudioSource> sources;
    private final ByteBuffer samples = BufferUtils.createByteBuffer((int)1040);

    public VCOutputClient(ProxVCClient vcClient) {
        this.vcClient = vcClient;
        this.socket = vcClient.socket;
        this.packet = new DatagramPacketWrapper(this.socket, 1044);
        this.sources = vcClient.sources;
    }

    @Override
    public void run() {
        while (!this.socket.isClosed()) {
            try {
                this.receiveNextPacket();
            }
            catch (SocketException socketException) {
            }
            catch (Exception ex) {
                System.out.println("Caught an exception during the output client loop.");
                ex.printStackTrace();
            }
        }
        System.out.println("Exited output client loop.");
    }

    private void receiveNextPacket() throws Exception {
        this.packet.receive();
        if (this.vcClient.isDisconnected()) {
            return;
        }
        int entityId = this.packet.buffer.getInt();
        StreamingAudioSource source = this.sources.get(entityId);
        if (source == null) {
            return;
        }
        this.samples.limit(1040);
        BufferAES.decrypt(AES.clientKeyChain, this.packet.buffer, this.samples);
        this.samples.limit(1024);
        this.samples.rewind();
        source.queueSamples(this.samples);
    }
}

