/*
 * Decompiled with CFR 0.152.
 */
package fiveavian.proxvc.vc.client;

import fiveavian.proxvc.ProxVCClient;
import fiveavian.proxvc.util.BufferAES;
import fiveavian.proxvc.util.DatagramPacketWrapper;
import fiveavian.proxvc.vc.AudioInputDevice;
import fiveavian.proxvc.vc.StreamingAudioSource;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.util.helper.AES;

public class VCInputClient
implements Runnable {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(new byte[1024]);
    private static final int TICKS_UNTIL_NOOP_PACKET = 25;
    private final ProxVCClient vcClient;
    private final Minecraft client;
    private final DatagramSocket socket;
    private final DatagramPacketWrapper packet;
    private final AudioInputDevice device;
    private final Map<Integer, StreamingAudioSource> sources;
    private int ticksUntilNoopPacket = 25;

    public VCInputClient(ProxVCClient vcClient) {
        this.vcClient = vcClient;
        this.client = vcClient.client;
        this.socket = vcClient.socket;
        this.packet = new DatagramPacketWrapper(this.socket, 1048);
        this.device = vcClient.device;
        this.sources = vcClient.sources;
    }

    @Override
    public void run() {
        while (!this.socket.isClosed()) {
            try {
                Thread.sleep(10L);
                if (this.vcClient.isDisconnected()) continue;
                this.sendNextPacket();
            }
            catch (SocketException socketException) {
            }
            catch (Exception ex) {
                System.out.println("Caught an exception during the input client loop.");
                ex.printStackTrace();
            }
        }
        System.out.println("Exited input client loop.");
    }

    private void sendNextPacket() throws Exception {
        if (this.sources.isEmpty()) {
            return;
        }
        ByteBuffer samples = this.device.pollSamples();
        this.packet.buffer.rewind();
        this.packet.buffer.putInt(this.client.thePlayer.id);
        if (((Boolean)this.vcClient.isMuted.value).booleanValue() || ((Boolean)this.vcClient.usePushToTalk.value).booleanValue() && !this.vcClient.keyPushToTalk.isPressed() || samples == null) {
            --this.ticksUntilNoopPacket;
            if (this.ticksUntilNoopPacket > 0) {
                return;
            }
            this.ticksUntilNoopPacket = 25;
            samples = EMPTY_BUFFER;
        } else {
            this.ticksUntilNoopPacket = 25;
        }
        samples.rewind();
        BufferAES.encrypt(AES.clientKeyChain, samples, this.packet.buffer);
        this.packet.send(this.vcClient.serverAddress);
    }
}

