/*
 * Decompiled with CFR 0.152.
 */
package fiveavian.proxvc.vc;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;

public class StreamingAudioSource
implements AutoCloseable {
    private static final int NUM_BUFFERS = 8;
    public final int source = AL10.alGenSources();
    private final IntBuffer buffers = BufferUtils.createIntBuffer((int)8);
    private int bufferIndex = 0;
    private int numBuffersAvailable = 8;

    public StreamingAudioSource() {
        AL10.alGenBuffers((IntBuffer)this.buffers);
        AL10.alDistanceModel((int)53251);
        AL10.alSourcef((int)this.source, (int)4131, (float)32.0f);
        AL10.alSourcef((int)this.source, (int)4128, (float)16.0f);
    }

    public boolean queueSamples(ByteBuffer samples) {
        int numBuffersToUnqueue = AL10.alGetSourcei((int)this.source, (int)4118);
        this.numBuffersAvailable += numBuffersToUnqueue;
        for (int i = 0; i < numBuffersToUnqueue; ++i) {
            AL10.alSourceUnqueueBuffers((int)this.source);
        }
        if (this.numBuffersAvailable == 0) {
            return false;
        }
        AL10.alBufferData((int)this.buffers.get(this.bufferIndex), (int)4353, (ByteBuffer)samples, (int)16384);
        AL10.alSourceQueueBuffers((int)this.source, (int)this.buffers.get(this.bufferIndex));
        int state = AL10.alGetSourcei((int)this.source, (int)4112);
        if (state != 4114) {
            AL10.alSourcePlay((int)this.source);
        }
        --this.numBuffersAvailable;
        ++this.bufferIndex;
        this.bufferIndex %= 8;
        return true;
    }

    @Override
    public void close() {
        AL10.alDeleteSources((int)this.source);
        AL10.alDeleteBuffers((IntBuffer)this.buffers);
    }
}

