/*
 * Decompiled with CFR 0.152.
 */
package fiveavian.proxvc.vc;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALC11;
import org.lwjgl.openal.ALCdevice;
import org.lwjgl.openal.OpenALException;

public class AudioInputDevice
implements AutoCloseable {
    private static final int NUM_DEVICE_BUFFERS = 8;
    private final ByteBuffer samples = BufferUtils.createByteBuffer((int)1024);
    private final IntBuffer ints = BufferUtils.createIntBuffer((int)1);
    private ALCdevice device = null;

    public static String[] getSpecifiers() {
        String result = null;
        try {
            result = ALC10.alcGetString(null, (int)784);
        }
        catch (OpenALException ex) {
            ex.printStackTrace();
        }
        return result == null ? new String[]{} : result.split("\u0000");
    }

    public synchronized void open(String deviceName) {
        this.close();
        if (deviceName == null) {
            this.device = null;
        } else {
            this.device = ALC11.alcCaptureOpenDevice((String)deviceName, (int)16384, (int)4353, (int)4096);
            ALC11.alcCaptureStart((ALCdevice)this.device);
        }
    }

    public synchronized boolean isClosed() {
        return this.device == null;
    }

    public synchronized ByteBuffer pollSamples() {
        if (this.isClosed()) {
            return null;
        }
        this.ints.rewind();
        ALC10.alcGetInteger((ALCdevice)this.device, (int)786, (IntBuffer)this.ints);
        if (this.ints.get(0) < 512) {
            return null;
        }
        this.samples.rewind();
        ALC11.alcCaptureSamples((ALCdevice)this.device, (ByteBuffer)this.samples, (int)512);
        return this.samples;
    }

    @Override
    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        ALC11.alcCaptureStop((ALCdevice)this.device);
        ALC11.alcCaptureCloseDevice((ALCdevice)this.device);
    }
}

