/*
 * Decompiled with CFR 0.152.
 */
package fiveavian.proxvc.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import net.minecraft.client.option.KeyBinding;
import net.minecraft.client.option.Option;

public class OptionStore {
    public static void loadOptions(Path path, Option<?>[] options, KeyBinding[] keys) {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                return;
            }
            Properties properties = new Properties();
            properties.load(Files.newInputStream(path, new OpenOption[0]));
            for (Option<?> option : options) {
                if (!properties.containsKey(option.name)) continue;
                option.parse(properties.getProperty(option.name));
            }
            for (Option<?> option : keys) {
                if (!properties.containsKey(option.getId())) continue;
                option.fromOptionsString(properties.getProperty(option.getId()));
            }
        }
        catch (IOException ex) {
            System.out.println("Failed to load options.");
            ex.printStackTrace();
        }
    }

    public static void saveOptions(Path path, Option<?>[] options, KeyBinding[] keys) {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            Properties properties = new Properties();
            for (Option<?> option : options) {
                if (option.value == null) continue;
                properties.setProperty(option.name, option.getValueString());
            }
            for (Option<?> option : keys) {
                properties.setProperty(option.getId(), option.toOptionsString());
            }
            properties.store(Files.newOutputStream(path, new OpenOption[0]), null);
        }
        catch (IOException ex) {
            System.out.println("Failed to save options.");
            ex.printStackTrace();
        }
    }
}

