/*
 * Decompiled with CFR 0.152.
 */
package fiveavian.proxvc.gui;

import fiveavian.proxvc.vc.AudioInputDevice;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.options.components.OptionsComponent;
import net.minecraft.client.option.StringOption;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.lang.I18n;
import org.lwjgl.opengl.GL11;

public class MicrophoneListComponent
implements OptionsComponent {
    private static final int MARGIN = 3;
    private static final int BUTTON_HEIGHT = 16;
    private static final int BUTTON_HEIGHT_WITH_MARGIN = 19;
    private final AudioInputDevice device;
    private final StringOption specifierOption;
    private Minecraft mc;
    private String[] specifiers;
    private int updateTickCount = 0;

    public MicrophoneListComponent(AudioInputDevice device, StringOption specifierOption) {
        this.device = device;
        this.specifierOption = specifierOption;
    }

    public void init(Minecraft mc) {
        this.mc = mc;
        this.updateSpecifiers();
    }

    public void tick() {
        ++this.updateTickCount;
        if (this.updateTickCount >= 40) {
            this.updateTickCount = 0;
            this.updateSpecifiers();
        }
    }

    private void updateSpecifiers() {
        this.specifiers = AudioInputDevice.getSpecifiers();
        if (this.specifierOption.value == null) {
            return;
        }
        for (String specifier : this.specifiers) {
            if (!Objects.equals(specifier, this.specifierOption.value)) continue;
            return;
        }
        this.selectSpecifier(null);
    }

    private void selectSpecifier(String specifier) {
        this.specifierOption.value = specifier;
        this.device.open(specifier);
    }

    public int getHeight() {
        if (this.specifiers.length == 0) {
            return 20;
        }
        return 3 + this.specifiers.length * 19;
    }

    public void render(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        Tessellator tessellator = Tessellator.instance;
        FontRenderer fontRenderer = this.mc.fontRenderer;
        I18n i18n = I18n.getInstance();
        if (this.specifiers.length == 0) {
            fontRenderer.drawCenteredString(i18n.translateKey("gui.options.page.proxvc.label.no_devices"), x + width / 2, y + 4, 0x5F7F7F7F);
            return;
        }
        y += 3;
        for (String specifier : this.specifiers) {
            if (Objects.equals(specifier, this.specifierOption.value)) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3553);
                tessellator.startDrawingQuads();
                tessellator.setColorOpaque_I(0x808080);
                tessellator.addVertexWithUV((double)(x - 2), (double)(y + 16 + 2), 0.0, 0.0, 1.0);
                tessellator.addVertexWithUV((double)(x + width + 2), (double)(y + 16 + 2), 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV((double)(x + width + 2), (double)(y - 2), 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV((double)(x - 2), (double)(y - 2), 0.0, 0.0, 0.0);
                tessellator.setColorOpaque_I(0);
                tessellator.addVertexWithUV((double)(x - 1), (double)(y + 16 + 1), 0.0, 0.0, 1.0);
                tessellator.addVertexWithUV((double)(x + width + 1), (double)(y + 16 + 1), 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV((double)(x + width + 1), (double)(y - 1), 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV((double)(x - 1), (double)(y - 1), 0.0, 0.0, 0.0);
                tessellator.draw();
                GL11.glEnable((int)3553);
            }
            fontRenderer.drawString(specifier, x + 1, y + 4, 0xFFFFFF);
            y += 19;
        }
    }

    public void onMouseClick(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        if (relativeMouseX < 0 || relativeMouseX >= width) {
            return;
        }
        y = 3;
        for (String specifier : this.specifiers) {
            if (relativeMouseY >= y && relativeMouseY < y + 16) {
                if (Objects.equals(specifier, this.specifierOption.value)) {
                    this.selectSpecifier(null);
                    break;
                }
                this.selectSpecifier(specifier);
                break;
            }
            y += 19;
        }
    }

    public void onMouseMove(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
    }

    public void onMouseRelease(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
    }

    public void onKeyPress(int keyCode, char character) {
    }

    public boolean matchesSearchTerm(String string) {
        return false;
    }
}

