/*
 * Decompiled with CFR 0.152.
 */
package fiveavian.proxvc;

import fiveavian.proxvc.api.ClientEvents;
import fiveavian.proxvc.gui.MicrophoneListComponent;
import fiveavian.proxvc.util.OptionStore;
import fiveavian.proxvc.vc.AudioInputDevice;
import fiveavian.proxvc.vc.StreamingAudioSource;
import fiveavian.proxvc.vc.client.VCInputClient;
import fiveavian.proxvc.vc.client.VCOutputClient;
import java.net.DatagramSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.options.components.BooleanOptionComponent;
import net.minecraft.client.gui.options.components.FloatOptionComponent;
import net.minecraft.client.gui.options.components.KeyBindingComponent;
import net.minecraft.client.gui.options.components.OptionsCategory;
import net.minecraft.client.gui.options.components.OptionsComponent;
import net.minecraft.client.gui.options.data.OptionsPage;
import net.minecraft.client.gui.options.data.OptionsPages;
import net.minecraft.client.input.InputDevice;
import net.minecraft.client.option.BooleanOption;
import net.minecraft.client.option.FloatOption;
import net.minecraft.client.option.KeyBinding;
import net.minecraft.client.option.Option;
import net.minecraft.client.option.StringOption;
import net.minecraft.client.render.WorldRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.net.packet.Packet1Login;
import net.minecraft.core.util.phys.Vec3d;
import org.lwjgl.openal.AL10;
import org.lwjgl.opengl.GL11;

public class ProxVCClient
implements ClientModInitializer {
    public Minecraft client;
    public DatagramSocket socket;
    public AudioInputDevice device;
    public final Map<Integer, StreamingAudioSource> sources = new HashMap<Integer, StreamingAudioSource>();
    public SocketAddress serverAddress;
    private Thread inputThread;
    private Thread outputThread;
    public final KeyBinding keyMute = new KeyBinding("key.mute").setDefault(InputDevice.keyboard, 50);
    public final KeyBinding keyPushToTalk = new KeyBinding("key.push_to_talk").setDefault(InputDevice.keyboard, 47);
    public final KeyBinding[] keyBindings = new KeyBinding[]{this.keyMute, this.keyPushToTalk};
    public FloatOption voiceChatVolume;
    public BooleanOption isMuted;
    public BooleanOption usePushToTalk;
    public StringOption selectedInputDevice;
    public Option<?>[] options;
    public Path optionFilePath;
    private boolean isMutePressed = false;

    public boolean isDisconnected() {
        return !this.client.isMultiplayerWorld() || this.serverAddress == null;
    }

    public void onInitializeClient() {
        ClientEvents.START.add(this::start);
        ClientEvents.STOP.add(this::stop);
        ClientEvents.TICK.add(this::tick);
        ClientEvents.RENDER.add(this::render);
        ClientEvents.LOGIN.add(this::login);
        ClientEvents.DISCONNECT.add(this::disconnect);
    }

    private void start(Minecraft client) {
        this.client = client;
        this.voiceChatVolume = new FloatOption(client.gameSettings, "sound.voice_chat", 1.0f);
        this.isMuted = new BooleanOption(client.gameSettings, "is_muted", false);
        this.usePushToTalk = new BooleanOption(client.gameSettings, "use_push_to_talk", false);
        this.selectedInputDevice = new StringOption(client.gameSettings, "selected_input_device", null);
        this.options = new Option[]{this.voiceChatVolume, this.isMuted, this.usePushToTalk, this.selectedInputDevice};
        this.optionFilePath = FabricLoader.getInstance().getConfigDir().resolve("proxvc_client.properties");
        OptionStore.loadOptions(this.optionFilePath, this.options, this.keyBindings);
        OptionStore.saveOptions(this.optionFilePath, this.options, this.keyBindings);
        try {
            this.socket = new DatagramSocket();
            this.device = new AudioInputDevice();
            this.serverAddress = null;
            this.inputThread = new Thread(new VCInputClient(this));
            this.outputThread = new Thread(new VCOutputClient(this));
            this.inputThread.start();
            this.outputThread.start();
            OptionsCategory generalCategory = new OptionsCategory("gui.options.page.proxvc.category.general").withComponent((OptionsComponent)new FloatOptionComponent(this.voiceChatVolume)).withComponent((OptionsComponent)new BooleanOptionComponent(this.isMuted)).withComponent((OptionsComponent)new BooleanOptionComponent(this.usePushToTalk));
            OptionsCategory devicesCategory = new OptionsCategory("gui.options.page.proxvc.category.devices").withComponent((OptionsComponent)new MicrophoneListComponent(this.device, this.selectedInputDevice));
            OptionsCategory controlsCategory = new OptionsCategory("gui.options.page.proxvc.category.controls").withComponent((OptionsComponent)new KeyBindingComponent(this.keyMute)).withComponent((OptionsComponent)new KeyBindingComponent(this.keyPushToTalk));
            OptionsPages.register((OptionsPage)new OptionsPage("gui.options.page.proxvc.title", Block.noteblock.getDefaultStack())).withComponent((OptionsComponent)generalCategory).withComponent((OptionsComponent)devicesCategory).withComponent((OptionsComponent)controlsCategory);
            this.device.open((String)this.selectedInputDevice.value);
        }
        catch (SocketException ex) {
            System.out.println("Failed to start the ProxVC client because of an exception.");
            System.out.println("Continuing without ProxVC.");
            ex.printStackTrace();
        }
    }

    private void stop(Minecraft client) {
        if (this.optionFilePath != null) {
            OptionStore.saveOptions(this.optionFilePath, this.options, this.keyBindings);
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
            if (this.inputThread != null) {
                this.inputThread.join();
            }
            if (this.outputThread != null) {
                this.outputThread.join();
            }
            if (this.device != null) {
                this.device.close();
            }
        }
        catch (InterruptedException ex) {
            System.out.println("Failed to stop the ProxVC client because of an exception.");
            ex.printStackTrace();
        }
    }

    private void tick(Minecraft client) {
        if (this.isDisconnected()) {
            return;
        }
        HashSet<Integer> toRemove = new HashSet<Integer>(this.sources.keySet());
        HashSet<Integer> toAdd = new HashSet<Integer>();
        for (Entity entity : client.theWorld.loadedEntityList) {
            if (!(entity instanceof EntityPlayer) || entity.id == client.thePlayer.id) continue;
            toRemove.remove(entity.id);
            toAdd.add(entity.id);
        }
        Iterator iterator = toRemove.iterator();
        while (iterator.hasNext()) {
            int entityId = (Integer)iterator.next();
            this.sources.remove(entityId).close();
        }
        iterator = toAdd.iterator();
        while (iterator.hasNext()) {
            int entityId = (Integer)iterator.next();
            if (this.sources.containsKey(entityId)) continue;
            this.sources.put(entityId, new StreamingAudioSource());
        }
        if (client.currentScreen == null) {
            if (this.keyMute.isPressEvent(InputDevice.keyboard)) {
                this.isMutePressed = true;
            }
            if (this.keyMute.isReleaseEvent(InputDevice.keyboard) && this.isMutePressed) {
                this.isMutePressed = false;
                this.isMuted.value = (Boolean)this.isMuted.value == false;
            }
        }
        for (Entity entity : client.theWorld.loadedEntityList) {
            StreamingAudioSource source = this.sources.get(entity.id);
            if (source == null) continue;
            Vec3d look = entity.getLookAngle();
            AL10.alDistanceModel((int)53251);
            AL10.alSourcef((int)source.source, (int)4131, (float)32.0f);
            AL10.alSourcef((int)source.source, (int)4128, (float)16.0f);
            AL10.alSource3f((int)source.source, (int)4100, (float)((float)entity.x), (float)((float)entity.y), (float)((float)entity.z));
            AL10.alSource3f((int)source.source, (int)4101, (float)((float)look.xCoord), (float)((float)look.yCoord), (float)((float)look.zCoord));
            AL10.alSource3f((int)source.source, (int)4102, (float)((float)entity.xd), (float)((float)entity.yd), (float)((float)entity.zd));
            AL10.alSourcef((int)source.source, (int)4106, (float)((Float)this.voiceChatVolume.value).floatValue());
        }
    }

    private void render(Minecraft client, WorldRenderer renderer) {
        if (this.isDisconnected() || !client.gameSettings.immersiveMode.drawOverlays()) {
            return;
        }
        GL11.glBindTexture((int)3553, (int)client.renderEngine.getTexture("/proxvc.png"));
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        double u = 0.0;
        if (((Boolean)this.isMuted.value).booleanValue()) {
            u = 0.25;
        } else if (this.device.isClosed()) {
            u = 0.5;
        } else if (((Boolean)this.usePushToTalk.value).booleanValue() && !this.keyPushToTalk.isPressed()) {
            u = 0.75;
        }
        Tessellator.instance.startDrawingQuads();
        Tessellator.instance.setColorRGBA_F(1.0f, 1.0f, 1.0f, 0.5f);
        Tessellator.instance.drawRectangleWithUV(4, client.resolution.scaledHeight - 24 - 4, 24, 24, u, 0.0, 0.25, 1.0);
        Tessellator.instance.draw();
    }

    private void login(Minecraft client, Packet1Login packet) {
        Socket socket = client.getSendQueue().netManager.networkSocket;
        this.serverAddress = socket.getRemoteSocketAddress();
    }

    private void disconnect(Minecraft client) {
        this.serverAddress = null;
        for (StreamingAudioSource source : this.sources.values()) {
            source.close();
        }
        this.sources.clear();
    }
}

