/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.saveddata.maps;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.ListTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import net.minecraft.core.world.saveddata.SavedData;
import net.minecraft.core.world.saveddata.maps.MapWaypoint;

public class ItemMapSavedData
extends SavedData {
    public int x;
    public int z;
    public byte dimension;
    public byte scale;
    public byte[] colors = new byte[16384];
    public int step;
    public List<HoldingPlayer> carriedBy = new ArrayList<HoldingPlayer>();
    private final Map<EntityPlayer, HoldingPlayer> carriedByPlayers = new HashMap<EntityPlayer, HoldingPlayer>();
    public List<MapDecoration> decorations = new ArrayList<MapDecoration>();
    public final int MAX_WAYPOINTS = 16;
    public List<MapWaypoint> mapWaypoints = new ArrayList<MapWaypoint>();

    public ItemMapSavedData(String id) {
        super(id);
    }

    @Override
    public void load(CompoundTag tag) {
        this.dimension = tag.getByte("dimension");
        this.x = tag.getInteger("xCenter");
        this.z = tag.getInteger("zCenter");
        this.scale = tag.getByte("scale");
        if (this.scale < 0) {
            this.scale = 0;
        }
        if (this.scale > 4) {
            this.scale = (byte)4;
        }
        int width = tag.getShort("width");
        int height = tag.getShort("height");
        if (width == 128 && height == 128) {
            this.colors = tag.getByteArray("colors");
        } else {
            byte[] abyte0 = tag.getByteArray("colors");
            this.colors = new byte[16384];
            int i = (128 - width) / 2;
            int j = (128 - height) / 2;
            for (int k = 0; k < height; ++k) {
                int l = k + j;
                for (int i1 = 0; i1 < width; ++i1) {
                    int j1 = i1 + i;
                    this.colors[j1 + l * 128] = abyte0[i1 + k * width];
                }
            }
        }
        ListTag waypointsList = tag.getList("Waypoints");
        for (int index = 0; index < waypointsList.tagCount(); ++index) {
            CompoundTag waypointNBT = (CompoundTag)waypointsList.tagAt(index);
            this.mapWaypoints.add(new MapWaypoint(waypointNBT));
        }
    }

    @Override
    public void save(CompoundTag tag) {
        tag.putByte("dimension", this.dimension);
        tag.putInt("xCenter", this.x);
        tag.putInt("zCenter", this.z);
        tag.putByte("scale", this.scale);
        tag.putShort("width", (short)128);
        tag.putShort("height", (short)128);
        tag.putByteArray("colors", this.colors);
        ListTag waypointsList = new ListTag();
        for (MapWaypoint mapWaypoint : this.mapWaypoints) {
            if (mapWaypoint == null) continue;
            CompoundTag waypointNBT = new CompoundTag();
            mapWaypoint.writeToNBT(waypointNBT);
            waypointsList.addTag(waypointNBT);
        }
        tag.put("Waypoints", waypointsList);
    }

    public void tickCarriedBy(EntityPlayer player, ItemStack stack) {
        if (!this.carriedByPlayers.containsKey(player)) {
            HoldingPlayer mapinfo = new HoldingPlayer(player);
            this.carriedByPlayers.put(player, mapinfo);
            this.carriedBy.add(mapinfo);
        }
        this.decorations.clear();
        for (MapWaypoint mapWaypoint : this.mapWaypoints) {
            if (!(player.distanceToSqr(mapWaypoint.xPos, mapWaypoint.yPos, mapWaypoint.zPos) <= 256.0) || player.world.getBlockId(mapWaypoint.xPos, mapWaypoint.yPos, mapWaypoint.zPos) == Block.flag.id) continue;
            this.mapWaypoints.remove(mapWaypoint);
            break;
        }
        for (int i = 0; i < this.carriedBy.size(); ++i) {
            HoldingPlayer mapinfo1 = this.carriedBy.get(i);
            if (mapinfo1.player.removed || !mapinfo1.player.inventory.func_28018_c(stack)) {
                this.carriedByPlayers.remove(mapinfo1.player);
                this.carriedBy.remove(mapinfo1);
                continue;
            }
            float f = (float)(mapinfo1.player.x - (double)this.x) / (float)(1 << this.scale);
            float f1 = (float)(mapinfo1.player.z - (double)this.z) / (float)(1 << this.scale);
            int j = 64;
            int k = 64;
            if (f < (float)(-j) || f1 < (float)(-k) || f > (float)j || f1 > (float)k) continue;
            byte color = 0;
            byte xCoord = (byte)((double)(f * 2.0f) + 0.5);
            byte zCoord = (byte)((double)(f1 * 2.0f) + 0.5);
            byte rotation = (byte)((double)(player.yRot * 16.0f / 360.0f) + 0.5);
            if (this.dimension == 1) {
                int l = this.step / 10;
                rotation = (byte)(l * l * 34187121 + l * 121 >> 15 & 0xF);
            }
            if (mapinfo1.player.dimension != this.dimension) continue;
            this.decorations.add(new MapDecoration(color, xCoord, zCoord, rotation));
        }
    }

    public boolean createNewWaypoint(TileEntityFlag flag) {
        if (this.mapWaypoints.size() >= 16) {
            return false;
        }
        float xd = (float)((double)flag.x - (double)this.x) / (float)(1 << this.scale);
        float zd = (float)((double)flag.z - (double)this.z) / (float)(1 << this.scale);
        int maxWidth = 64;
        int maxHeight = 64;
        byte xCoord = (byte)((double)(xd * 2.0f) + 0.5);
        byte zCoord = (byte)((double)(zd * 2.0f) + 0.5);
        if (xd < (float)(-maxWidth) || zd < (float)(-maxHeight) || xd > (float)maxWidth || zd > (float)maxHeight) {
            return false;
        }
        byte[] colors = new byte[9];
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                colors[x * 3 + y] = flag.getColor(12 * x, 8 * y);
            }
        }
        this.mapWaypoints.add(new MapWaypoint(xCoord, zCoord, flag.x, flag.y, flag.z, colors));
        return true;
    }

    public byte[] getMapDataBytes(ItemStack stack, World world, EntityPlayer player) {
        HoldingPlayer mapinfo = this.carriedByPlayers.get(player);
        if (mapinfo == null) {
            return null;
        }
        return mapinfo.nextUpdatePacket(stack);
    }

    public void setDirty(int x, int y, int z) {
        super.setDirty();
        for (HoldingPlayer mapinfo : this.carriedBy) {
            if (mapinfo.minDirty[x] < 0 || mapinfo.minDirty[x] > y) {
                mapinfo.minDirty[x] = y;
            }
            if (mapinfo.maxDirty[x] >= 0 && mapinfo.maxDirty[x] >= z) continue;
            mapinfo.maxDirty[x] = z;
        }
    }

    public ItemMapSavedData setColors(byte[] colors) {
        if (colors[0] == 0) {
            int i = colors[1] & 0xFF;
            int k = colors[2] & 0xFF;
            for (int l = 0; l < colors.length - 3; ++l) {
                this.colors[(l + k) * 128 + i] = colors[l + 3];
            }
            this.setDirty();
        } else if (colors[0] == 1) {
            this.decorations.clear();
            for (int j = 0; j < (colors.length - 1) / 3; ++j) {
                byte byte0 = (byte)(colors[j * 3 + 1] % 16);
                byte byte1 = colors[j * 3 + 2];
                byte byte2 = colors[j * 3 + 3];
                byte byte3 = (byte)(colors[j * 3 + 1] / 16);
                this.decorations.add(new MapDecoration(byte0, byte1, byte2, byte3));
            }
        }
        return this;
    }

    public void setMapWaypoints(List<MapWaypoint> waypoints) {
        this.mapWaypoints = waypoints;
    }

    public static class MapDecoration {
        public byte type;
        public byte x;
        public byte y;
        public byte rot;

        public MapDecoration(byte type, byte x, byte y, byte rot) {
            this.type = type;
            this.x = x;
            this.y = y;
            this.rot = rot;
        }
    }

    public class HoldingPlayer {
        public final EntityPlayer player;
        public int[] minDirty = new int[128];
        public int[] maxDirty = new int[128];
        private int tick = 0;
        private int step = 0;
        private byte[] packetBuffer;

        public HoldingPlayer(EntityPlayer player) {
            this.player = player;
            for (int i = 0; i < this.minDirty.length; ++i) {
                this.minDirty[i] = 0;
                this.maxDirty[i] = 127;
            }
        }

        public byte[] nextUpdatePacket(ItemStack stack) {
            if (--this.step < 0) {
                this.step = 4;
                byte[] mapCoordinates = new byte[ItemMapSavedData.this.decorations.size() * 3 + 1];
                mapCoordinates[0] = 1;
                for (int j = 0; j < ItemMapSavedData.this.decorations.size(); ++j) {
                    MapDecoration decoration = ItemMapSavedData.this.decorations.get(j);
                    mapCoordinates[j * 3 + 1] = (byte)(decoration.type + (decoration.rot & 0xF) * 16);
                    mapCoordinates[j * 3 + 2] = decoration.x;
                    mapCoordinates[j * 3 + 3] = decoration.y;
                }
                boolean flag = true;
                if (this.packetBuffer == null || this.packetBuffer.length != mapCoordinates.length) {
                    flag = false;
                } else {
                    for (int l = 0; l < mapCoordinates.length; ++l) {
                        if (mapCoordinates[l] == this.packetBuffer[l]) continue;
                        flag = false;
                        break;
                    }
                }
                if (!flag) {
                    this.packetBuffer = mapCoordinates;
                    return mapCoordinates;
                }
            }
            for (int i = 0; i < 10; ++i) {
                int k = this.tick * 11 % 128;
                ++this.tick;
                if (this.minDirty[k] < 0) continue;
                int i1 = this.maxDirty[k] - this.minDirty[k] + 1;
                int j1 = this.minDirty[k];
                byte[] abyte1 = new byte[i1 + 3];
                abyte1[0] = 0;
                abyte1[1] = (byte)k;
                abyte1[2] = (byte)j1;
                for (int k1 = 0; k1 < abyte1.length - 3; ++k1) {
                    abyte1[k1 + 3] = ItemMapSavedData.this.colors[(k1 + j1) * 128 + k];
                }
                this.maxDirty[k] = -1;
                this.minDirty[k] = -1;
                return abyte1;
            }
            return null;
        }
    }
}

