/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.NbtIo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.ChunkLoaderLegacy;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.save.mcregion.RegionFileCache;

public class ChunkLoaderRegion
implements IChunkLoader {
    private final File worldDir;

    public ChunkLoaderRegion(File worldDir) {
        this.worldDir = worldDir;
    }

    @Override
    public Chunk loadChunk(World world, int x, int z) throws IOException {
        DataInputStream regionStream = RegionFileCache.getChunkInputStream(this.worldDir, x, z);
        if (regionStream == null) {
            return null;
        }
        CompoundTag tag = NbtIo.read(regionStream);
        if (!tag.containsKey("Level")) {
            System.out.println("Chunk file at " + x + "," + z + " is missing level data, skipping");
            return null;
        }
        Chunk chunk = ChunkLoaderLegacy.loadChunkIntoWorldFromCompound(world, tag.getCompound("Level"));
        if (!chunk.isAtLocation(x, z)) {
            System.out.println("Chunk file at " + x + "," + z + " is in the wrong location; relocating. (Expected " + x + ", " + z + ", got " + chunk.xPosition + ", " + chunk.zPosition + ")");
            tag.putInt("xPos", x);
            tag.putInt("zPos", z);
            chunk = ChunkLoaderLegacy.loadChunkIntoWorldFromCompound(world, tag.getCompound("Level"));
        }
        chunk.fixMissingBlocks();
        return chunk;
    }

    @Override
    public void saveChunk(World world, Chunk chunk) throws IOException {
        world.checkSessionLock();
        try {
            DataOutputStream regionStream = RegionFileCache.getChunkOutputStream(this.worldDir, chunk.xPosition, chunk.zPosition);
            CompoundTag levelTag = new CompoundTag();
            CompoundTag chunkDataTag = new CompoundTag();
            levelTag.put("Level", chunkDataTag);
            ChunkLoaderLegacy.storeChunkInCompound(chunk, world, chunkDataTag);
            NbtIo.write(levelTag, regionStream);
            regionStream.close();
            LevelData levelData = world.getLevelData();
            levelData.setSizeOnDisk(levelData.getSizeOnDisk() + (long)RegionFileCache.getSizeDelta(this.worldDir, chunk.xPosition, chunk.zPosition));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

