/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;

public class Packet38EntityStatus
extends Packet {
    public int entityId;
    public byte entityStatus;
    public float attackedAtYaw;

    public Packet38EntityStatus() {
    }

    public Packet38EntityStatus(int entityId, byte entityStatus) {
        this.entityId = entityId;
        this.entityStatus = entityStatus;
        this.attackedAtYaw = 0.0f;
    }

    public Packet38EntityStatus(int entityId, byte entityStatus, float attackedAtYaw) {
        this.entityId = entityId;
        this.entityStatus = entityStatus;
        this.attackedAtYaw = attackedAtYaw;
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        this.entityId = dis.readInt();
        this.entityStatus = dis.readByte();
        this.attackedAtYaw = dis.readFloat();
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        dos.writeInt(this.entityId);
        dos.writeByte(this.entityStatus);
        dos.writeFloat(this.attackedAtYaw);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleEntityStatus(this);
    }

    @Override
    public int getPacketSize() {
        return 9;
    }
}

