/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.world.saveddata.maps.MapWaypoint;

public class Packet131MapData
extends Packet {
    public short itemId;
    public short meta;
    public byte[] mapData;
    public List<MapWaypoint> waypoints;

    public Packet131MapData() {
        this.isChunkDataPacket = true;
    }

    public Packet131MapData(short itemId, short meta, byte[] mapData, List<MapWaypoint> waypoints) {
        this.isChunkDataPacket = true;
        this.itemId = itemId;
        this.meta = meta;
        this.waypoints = waypoints;
        this.mapData = mapData;
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        this.itemId = dis.readShort();
        this.meta = dis.readShort();
        int wayPointAmount = dis.readByte();
        this.waypoints = new ArrayList<MapWaypoint>();
        for (int i = 0; i < wayPointAmount; ++i) {
            this.waypoints.add(new MapWaypoint(dis));
        }
        this.mapData = new byte[dis.readByte() & 0xFF];
        dis.readFully(this.mapData);
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        dos.writeShort(this.itemId);
        dos.writeShort(this.meta);
        dos.writeByte(this.waypoints.size());
        for (int i = 0; i < (int)this.waypoints.size(); ++i) {
            this.waypoints.get(i).writeToOutputStream(dos);
        }
        dos.writeByte(this.mapData.length);
        dos.write(this.mapData);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleMapData(this);
    }

    @Override
    public int getPacketSize() {
        return 4 + this.mapData.length;
    }
}

