/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class ItemSign
extends Item {
    public ItemSign(String name, int id) {
        super(name, id);
    }

    @Override
    public boolean onUseItemOnBlock(ItemStack itemstack, EntityPlayer entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        int sideHit = side.getId();
        if (side == Side.BOTTOM) {
            return false;
        }
        if (!world.getBlockMaterial(blockX, blockY, blockZ).isSolid()) {
            return false;
        }
        if (!world.canPlaceInsideBlock(blockX, blockY, blockZ)) {
            blockX += side.getOffsetX();
            blockY += side.getOffsetY();
            blockZ += side.getOffsetZ();
        }
        if (blockY < 0 || blockY >= world.getHeightBlocks()) {
            return false;
        }
        if (!Block.signPostPlanksOak.canPlaceBlockAt(world, blockX, blockY, blockZ)) {
            return false;
        }
        if (sideHit == 1) {
            world.playBlockSoundEffect(entityplayer, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, Block.signPostPlanksOak, EnumBlockSoundEffectType.PLACE);
            world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, Block.signPostPlanksOak.id, MathHelper.floor_double((double)((entityplayer.yRot + 180.0f) * 16.0f / 360.0f) + 0.5) & 0xF);
        } else {
            world.playBlockSoundEffect(entityplayer, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, Block.signWallPlanksOak, EnumBlockSoundEffectType.PLACE);
            world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, Block.signWallPlanksOak.id, sideHit);
        }
        itemstack.consumeItem(entityplayer);
        TileEntitySign tileentitysign = (TileEntitySign)world.getBlockTileEntity(blockX, blockY, blockZ);
        if (tileentitysign != null) {
            tileentitysign.setOwner(entityplayer);
            entityplayer.displayGUIEditSign(tileentitysign);
        }
        return true;
    }
}

