/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.entity.projectile.EntityPebble;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.IDispensable;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;

public class ItemPebble
extends Item
implements IDispensable {
    public ItemPebble(String name, int id) {
        super(name, id);
        this.maxStackSize = 64;
    }

    @Override
    public ItemStack onUseItem(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        itemstack.consumeItem(entityplayer);
        world.playSoundAtEntity(entityplayer, entityplayer, "random.bow", 0.5f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
        if (!world.isClientSide) {
            world.entityJoinedWorld(new EntityPebble(world, entityplayer));
        }
        return itemstack;
    }

    @Override
    public boolean onUseItemOnBlock(ItemStack itemstack, EntityPlayer entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        int newMeta;
        int id = world.getBlockId(blockX, blockY, blockZ);
        int meta = world.getBlockMetadata(blockX, blockY, blockZ);
        if (id != Block.overlayPebbles.id && Block.blocksList[id] != null && Block.blocksList[id].hasTag(BlockTags.PLACE_OVERWRITES)) {
            id = 0;
            meta = 0;
        }
        if (itemstack.stackSize <= 0) {
            return false;
        }
        if (blockY == world.getHeightBlocks() - 1 && Block.overlayPebbles.blockMaterial.isSolid()) {
            return false;
        }
        if (id == Block.overlayPebbles.id && side == Side.TOP) {
            newMeta = meta + 1;
            if (!world.isBlockOpaqueCube(blockX, blockY - 1, blockZ)) {
                return false;
            }
            if (newMeta < 3) {
                world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, Block.overlayPebbles.id, newMeta);
                world.playBlockSoundEffect(entityplayer, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, Block.overlayPebbles, EnumBlockSoundEffectType.PLACE);
                itemstack.consumeItem(entityplayer);
                return true;
            }
        }
        if (id != 0) {
            id = world.getBlockId(blockX += side.getOffsetX(), blockY += side.getOffsetY(), blockZ += side.getOffsetZ());
            meta = world.getBlockMetadata(blockX, blockY, blockZ);
        }
        if (id == Block.overlayPebbles.id) {
            newMeta = meta + 1;
            AABB bbBox = AABB.getBoundingBoxFromPool(blockX, blockY, blockZ, (float)blockX + 1.0f, (float)blockY + (float)(2 * (newMeta + 1)) / 16.0f, (float)blockZ + 1.0f);
            if (!world.checkIfAABBIsClear(bbBox) || !world.isBlockOpaqueCube(blockX, blockY - 1, blockZ)) {
                return false;
            }
            if (newMeta < 3) {
                world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, Block.overlayPebbles.id, newMeta);
                world.playBlockSoundEffect(entityplayer, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, Block.overlayPebbles, EnumBlockSoundEffectType.PLACE);
                itemstack.consumeItem(entityplayer);
                return true;
            }
        }
        if (world.canBlockBePlacedAt(Block.overlayPebbles.id, blockX, blockY, blockZ, false, side) && world.isBlockOpaqueCube(blockX, blockY - 1, blockZ)) {
            Block block = Block.overlayPebbles;
            if (world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, Block.overlayPebbles.id, this.getPlacedBlockMetadata(itemstack.getMetadata()))) {
                Block.overlayPebbles.onBlockPlaced(world, blockX, blockY, blockZ, side, entityplayer, yPlaced);
                world.playBlockSoundEffect(entityplayer, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, Block.overlayPebbles, EnumBlockSoundEffectType.PLACE);
                itemstack.consumeItem(entityplayer);
            }
            return true;
        }
        return false;
    }

    @Override
    public void onDispensed(ItemStack itemStack, World world, double x, double y, double z, int xOffset, int zOffset, Random random) {
        EntityPebble pebble = new EntityPebble(world, x, y, z);
        pebble.setHeading(xOffset, 0.1, zOffset, 1.1f, 6.0f);
        world.entityJoinedWorld(pebble);
    }
}

