/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.piston;

import java.util.ArrayList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.logic.PistonDirections;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.piston.BlockPistonMoving;
import net.minecraft.core.block.piston.TileEntityPistonMoving;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.block.ItemBlockPiston;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockPistonBase
extends Block {
    private boolean isSticky;

    public BlockPistonBase(String key, int id, boolean isSticky) {
        super(key, id, Material.piston);
        this.isSticky = isSticky;
        this.setBlockItem(() -> new ItemBlockPiston(this));
        this.withHardness(0.5f);
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public void onBlockPlaced(World world, int x, int y, int z, Side side, EntityLiving entity, double sideHeight) {
        Direction placementDirection = entity.getPlacementDirection(side).getOpposite();
        world.setBlockMetadataWithNotify(x, y, z, placementDirection.getId());
        if (!world.isClientSide) {
            this.checkIfExtend(world, x, y, z);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        this.checkIfExtend(world, x, y, z);
    }

    @Override
    public void onBlockAdded(World world, int x, int y, int z) {
        if (!world.isClientSide && world.getBlockTileEntity(x, y, z) == null) {
            this.checkIfExtend(world, x, y, z);
        }
    }

    private void checkIfExtend(World world, int x, int y, int z) {
        int data = world.getBlockMetadata(x, y, z);
        int direction = BlockPistonBase.getDirection(data);
        boolean hasNeighborSignal = this.getNeighborSignal(world, x, y, z, direction);
        if (data == 7) {
            return;
        }
        if (hasNeighborSignal && !BlockPistonBase.isPowered(data)) {
            if (BlockPistonBase.canPushLine(world, x, y, z, direction)) {
                world.setBlockMetadata(x, y, z, direction | 8);
                world.triggerEvent(x, y, z, 0, direction);
            }
        } else if (!hasNeighborSignal && BlockPistonBase.isPowered(data)) {
            world.setBlockMetadata(x, y, z, direction);
            world.triggerEvent(x, y, z, 1, direction);
        }
    }

    private boolean getNeighborSignal(World world, int x, int y, int z, int direction) {
        if (direction != 0 && world.isBlockIndirectlyProvidingPowerTo(x, y - 1, z, 0)) {
            return true;
        }
        if (direction != 1 && world.isBlockIndirectlyProvidingPowerTo(x, y + 1, z, 1)) {
            return true;
        }
        if (direction != 2 && world.isBlockIndirectlyProvidingPowerTo(x, y, z - 1, 2)) {
            return true;
        }
        if (direction != 3 && world.isBlockIndirectlyProvidingPowerTo(x, y, z + 1, 3)) {
            return true;
        }
        if (direction != 5 && world.isBlockIndirectlyProvidingPowerTo(x + 1, y, z, 5)) {
            return true;
        }
        if (direction != 4 && world.isBlockIndirectlyProvidingPowerTo(x - 1, y, z, 4)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(x, y, z, 0)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(x, y + 2, z, 1)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(x, y + 1, z - 1, 2)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(x, y + 1, z + 1, 3)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(x - 1, y + 1, z, 4)) {
            return true;
        }
        return world.isBlockIndirectlyProvidingPowerTo(x + 1, y + 1, z, 5);
    }

    @Override
    public void triggerEvent(World world, int x, int y, int z, int index, int data) {
        int direction = data;
        if (direction >= 6) {
            direction = 0;
        }
        if (index == 0) {
            if (this.tryExtend(world, x, y, z, direction)) {
                world.setBlockMetadataWithNotify(x, y, z, direction | 8);
                world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.out", 0.5f, world.rand.nextFloat() * 0.25f + 0.6f);
            }
        } else if (index == 1) {
            TileEntity tileentity = world.getBlockTileEntity(x + PistonDirections.xOffset[direction], y + PistonDirections.yOffset[direction], z + PistonDirections.zOffset[direction]);
            if (tileentity != null && tileentity instanceof TileEntityPistonMoving) {
                ((TileEntityPistonMoving)tileentity).finalTick();
            }
            world.setBlockAndMetadata(x, y, z, Block.pistonMoving.id, direction);
            world.setBlockTileEntity(x, y, z, BlockPistonMoving.createTileEntity(this.id, direction, direction, false, true));
            if (this.isSticky) {
                TileEntityPistonMoving tileentitypiston;
                TileEntity tileentity1;
                int x1 = x + PistonDirections.xOffset[direction] * 2;
                int y1 = y + PistonDirections.yOffset[direction] * 2;
                int z1 = z + PistonDirections.zOffset[direction] * 2;
                int id1 = world.getBlockId(x1, y1, z1);
                int meta1 = world.getBlockMetadata(x1, y1, z1);
                boolean flag = false;
                if (id1 == Block.pistonMoving.id && (tileentity1 = world.getBlockTileEntity(x1, y1, z1)) != null && tileentity1 instanceof TileEntityPistonMoving && (tileentitypiston = (TileEntityPistonMoving)tileentity1).getDirection() == direction && tileentitypiston.isExtending()) {
                    tileentitypiston.finalTick();
                    id1 = tileentitypiston.getMovedId();
                    meta1 = tileentitypiston.getMovedData();
                    flag = true;
                }
                if (!flag && id1 > 0 && BlockPistonBase.isPushable(id1, world, x1, y1, z1, false) && (Block.blocksList[id1].getPistonPushReaction() == 0 || id1 == Block.pistonBase.id || id1 == Block.pistonBaseSticky.id)) {
                    world.setBlockWithNotify(x1, y1, z1, 0);
                    world.setBlockAndMetadata(x += PistonDirections.xOffset[direction], y += PistonDirections.yOffset[direction], z += PistonDirections.zOffset[direction], Block.pistonMoving.id, meta1);
                    world.setBlockTileEntity(x, y, z, BlockPistonMoving.createTileEntity(id1, meta1, direction, false, false));
                } else if (!flag) {
                    world.setBlockWithNotify(x + PistonDirections.xOffset[direction], y + PistonDirections.yOffset[direction], z + PistonDirections.zOffset[direction], 0);
                }
            } else {
                world.setBlockWithNotify(x + PistonDirections.xOffset[direction], y + PistonDirections.yOffset[direction], z + PistonDirections.zOffset[direction], 0);
            }
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.in", 0.5f, world.rand.nextFloat() * 0.15f + 0.6f);
        }
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        if (BlockPistonBase.isPowered(l)) {
            switch (BlockPistonBase.getDirection(l)) {
                case 0: {
                    this.setBlockBounds(0.0, 0.25, 0.0, 1.0, 1.0, 1.0);
                    break;
                }
                case 1: {
                    this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
                    break;
                }
                case 2: {
                    this.setBlockBounds(0.0, 0.0, 0.25, 1.0, 1.0, 1.0);
                    break;
                }
                case 3: {
                    this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 0.75);
                    break;
                }
                case 4: {
                    this.setBlockBounds(0.25, 0.0, 0.0, 1.0, 1.0, 1.0);
                    break;
                }
                case 5: {
                    this.setBlockBounds(0.0, 0.0, 0.0, 0.75, 1.0, 1.0);
                }
            }
        } else {
            this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
    }

    @Override
    public void getCollidingBoundingBoxes(World world, int x, int y, int z, AABB aabb, ArrayList<AABB> aabbs) {
        this.setBlockBoundsBasedOnState(world, x, y, z);
        super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbs);
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    public static int getDirection(int data) {
        return data & 7;
    }

    public static boolean isPowered(int data) {
        return (data & 8) != 0;
    }

    private static boolean isPushable(int id, World world, int x, int y, int z, boolean canDestroy) {
        TileEntity tileentity;
        if (id == Block.obsidian.id) {
            return false;
        }
        if (id == Block.pistonBase.id || id == Block.pistonBaseSticky.id) {
            if (BlockPistonBase.isPowered(world.getBlockMetadata(x, y, z))) {
                return false;
            }
        } else {
            if (Block.blocksList[id].getHardness() == -1.0f) {
                return false;
            }
            if (Block.blocksList[id].getPistonPushReaction() == 2) {
                return false;
            }
            if (Block.blocksList[id].getImmovable()) {
                return false;
            }
            if (!canDestroy && Block.blocksList[id].getPistonPushReaction() == 1) {
                return false;
            }
        }
        return (tileentity = world.getBlockTileEntity(x, y, z)) == null;
    }

    private static boolean canPushLine(World world, int x, int y, int z, int direction) {
        int xo = x + PistonDirections.xOffset[direction % 6];
        int yo = y + PistonDirections.yOffset[direction % 6];
        int zo = z + PistonDirections.zOffset[direction % 6];
        for (int i = 0; i < 13; ++i) {
            if (yo <= 0 || yo >= world.getHeightBlocks() - 1) {
                return false;
            }
            int id = world.getBlockId(xo, yo, zo);
            if (id == 0) break;
            if (!BlockPistonBase.isPushable(id, world, xo, yo, zo, true)) {
                if (i == 1 && (id == Block.obsidian.id || id == Block.bedrock.id)) {
                    int x2 = x + PistonDirections.xOffset[direction % 6];
                    int y2 = y + PistonDirections.yOffset[direction % 6];
                    int z2 = z + PistonDirections.zOffset[direction % 6];
                    world.playSoundEffect(null, 2001, x2, y2, z2, world.getBlockId(x2, y2, z2));
                    Block.blocksList[world.getBlockId(x2, y2, z2)].dropBlockWithCause(world, EnumDropCause.SILK_TOUCH, x2, y2, z2, world.getBlockMetadata(x2, y2, z2), null);
                    world.setBlockWithNotify(x2, y2, z2, 0);
                    break;
                }
                return false;
            }
            if (Block.blocksList[id].getPistonPushReaction() == 1) break;
            if (i == 12) {
                return false;
            }
            xo += PistonDirections.xOffset[direction % 6];
            yo += PistonDirections.yOffset[direction % 6];
            zo += PistonDirections.zOffset[direction % 6];
        }
        return true;
    }

    private boolean tryExtend(World world, int x, int y, int z, int direction) {
        int i1 = x + PistonDirections.xOffset[direction % 6];
        int j1 = y + PistonDirections.yOffset[direction % 6];
        int k1 = z + PistonDirections.zOffset[direction % 6];
        for (int l1 = 0; l1 < 13; ++l1) {
            if (j1 <= 0 || j1 >= world.getHeightBlocks() - 1) {
                return false;
            }
            int j2 = world.getBlockId(i1, j1, k1);
            if (j2 == 0) break;
            if (!BlockPistonBase.isPushable(j2, world, i1, j1, k1, true)) {
                return false;
            }
            if (Block.blocksList[j2].getPistonPushReaction() == 1) {
                Block.blocksList[j2].dropBlockWithCause(world, EnumDropCause.WORLD, i1, j1, k1, world.getBlockMetadata(i1, j1, k1), null);
                world.setBlockWithNotify(i1, j1, k1, 0);
                break;
            }
            if (l1 == 12) {
                return false;
            }
            i1 += PistonDirections.xOffset[direction % 6];
            j1 += PistonDirections.yOffset[direction % 6];
            k1 += PistonDirections.zOffset[direction % 6];
        }
        int l2 = 0;
        while (i1 != x || j1 != y || k1 != z) {
            int i2 = i1 - PistonDirections.xOffset[direction % 6];
            int k2 = j1 - PistonDirections.yOffset[direction % 6];
            l2 = k1 - PistonDirections.zOffset[direction % 6];
            int i3 = world.getBlockId(i2, k2, l2);
            int j3 = world.getBlockMetadata(i2, k2, l2);
            if (i3 == this.id && i2 == x && k2 == y && l2 == z) {
                world.setBlockAndMetadata(i1, j1, k1, Block.pistonMoving.id, direction | (this.isSticky ? 8 : 0));
                world.setBlockTileEntity(i1, j1, k1, BlockPistonMoving.createTileEntity(Block.pistonHead.id, direction | (this.isSticky ? 8 : 0), direction, true, false));
            } else {
                world.setBlockAndMetadata(i1, j1, k1, Block.pistonMoving.id, j3);
                world.setBlockTileEntity(i1, j1, k1, BlockPistonMoving.createTileEntity(i3, j3, direction, true, false));
            }
            i1 = i2;
            j1 = k2;
            k1 = l2;
        }
        return true;
    }
}

