/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.EntityTNT;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemFirestriker;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class BlockTNT
extends Block {
    public BlockTNT(String key, int id) {
        super(key, id, Material.explosive);
    }

    @Override
    public void onBlockAdded(World world, int x, int y, int z) {
        super.onBlockAdded(world, x, y, z);
        if (world.isBlockIndirectlyGettingPowered(x, y, z)) {
            this.ignite(world, x, y, z, true);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (blockId > 0 && Block.blocksList[blockId].canProvidePower() && world.isBlockIndirectlyGettingPowered(x, y, z)) {
            this.ignite(world, x, y, z, true);
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        if (dropCause == EnumDropCause.EXPLOSION) {
            return null;
        }
        return new ItemStack[]{new ItemStack(this)};
    }

    @Override
    public void onBlockDestroyedByExplosion(World world, int x, int y, int z) {
        EntityTNT entity = new EntityTNT(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
        entity.fuse = world.rand.nextInt(entity.fuse / 4) + entity.fuse / 8;
        world.entityJoinedWorld(entity);
    }

    public void ignite(World world, int x, int y, int z, boolean sound) {
        this.ignite(world, x, y, z, null, sound);
    }

    public void ignite(World world, int x, int y, int z, EntityPlayer player, boolean sound) {
        if (world.isClientSide) {
            if (player != null && player.inventory.getCurrentItem() != null && player.inventory.getCurrentItem().getItem() instanceof ItemFirestriker) {
                player.inventory.getCurrentItem().damageItem(1, player);
            }
            return;
        }
        world.setBlockWithNotify(x, y, z, 0);
        EntityTNT e = new EntityTNT(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
        world.entityJoinedWorld(e);
        world.playSoundAtEntity(null, e, "random.fuse", 1.0f, 1.0f);
        if (player != null && player.inventory.getCurrentItem() != null && player.inventory.getCurrentItem().getItem() instanceof ItemFirestriker) {
            player.inventory.getCurrentItem().damageItem(1, player);
        }
    }

    @Override
    public void onBlockLeftClicked(World world, int x, int y, int z, EntityPlayer player, Side side, double xHit, double yHit) {
        if (player.getCurrentEquippedItem() != null && player.getCurrentEquippedItem().getItem() instanceof ItemFirestriker) {
            world.setBlockMetadata(x, y, z, 1);
        }
        super.onBlockLeftClicked(world, x, y, z, player, side, xHit, yHit);
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, EntityPlayer player, Side side, double xPlaced, double yPlaced) {
        if (player.inventory.getCurrentItem() != null && player.inventory.getCurrentItem().getItem() instanceof ItemFirestriker) {
            this.ignite(world, x, y, z, player, true);
            return true;
        }
        return super.onBlockRightClicked(world, x, y, z, player, side, xPlaced, yPlaced);
    }
}

