/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.particle;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.fx.EntityNoteFX;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.modelviewer.categories.entries.particle.ParticleEntry;
import net.minecraft.client.gui.modelviewer.elements.GuiListenerSlider;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.world.World;

public class NoteFXEntry
extends ParticleEntry {
    protected int note = 0;
    protected final int maxNote = 24;

    @Override
    public String getParticleName(I18n translator) {
        return "note";
    }

    @Override
    public List<GuiButton> getEntryButtons(Minecraft mc, GuiScreen parentScreen) {
        final GuiListenerSlider noteSlider = new GuiListenerSlider(-1, -120, 0, 120, 20, I18n.getInstance().translateKeyAndFormat("model.category.particle.note.slider", this.getNoteString(this.note)), (float)this.note / 24.0f);
        noteSlider.setOnValueChanged(() -> {
            this.note = (int)(noteSlider.sliderValue * 24.0f);
            noteSlider.displayString = I18n.getInstance().translateKeyAndFormat("model.category.particle.note.slider", this.getNoteString(this.note));
        });
        return new ArrayList<GuiButton>(){
            {
                this.add(noteSlider);
            }
        };
    }

    private String getNoteString(int note) {
        return Integer.toHexString(note).length() == 1 ? "0" + Integer.toHexString(note) : Integer.toHexString(note);
    }

    @Override
    public void spawnParticle(Minecraft mc, World world, double x, double y, double z) {
        mc.effectRenderer.addEffect(new EntityNoteFX(world, x, y, z, (double)this.note / 24.0, 0.0, 0.0));
    }

    @Override
    public void onOpen() {
        this.note = 0;
    }

    @Override
    public void onClose() {
    }
}

