/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.hud.ComponentAnchor;
import net.minecraft.client.gui.hud.Layout;
import net.minecraft.client.gui.hud.MovableHudComponent;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.Scissor;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.InventoryPlayer;
import org.lwjgl.opengl.GL11;

public class HotbarComponent
extends MovableHudComponent {
    private static final ItemStack[] PREVIEW_ITEMS = new ItemStack[]{new ItemStack(Block.stone), new ItemStack(Block.cobbleStone), new ItemStack(Block.brickClay), new ItemStack(Block.dirt), new ItemStack(Block.planksOak), new ItemStack(Block.logOak), new ItemStack(Block.leavesOak), new ItemStack(Block.glass), new ItemStack(Block.slabStonePolished)};

    public HotbarComponent(String key, Layout layout) {
        super(key, 187, 22, layout);
    }

    @Override
    public int getAnchorX(ComponentAnchor anchor) {
        int xAnchor = super.getAnchorX(anchor);
        if (anchor.xPosition == 0.0f) {
            xAnchor += 5;
        } else if (anchor.xPosition == 0.5f) {
            xAnchor += 2;
        }
        return xAnchor;
    }

    @Override
    public boolean isVisible(Minecraft mc) {
        return mc.gameSettings.immersiveMode.drawHotbar();
    }

    @Override
    public void render(Minecraft mc, GuiIngame gui, int xSizeScreen, int ySizeScreen, float partialTick) {
        int itemY;
        int itemX;
        int itemIndex;
        int x = this.getLayout().getComponentX(mc, this, xSizeScreen);
        int y = this.getLayout().getComponentY(mc, this, ySizeScreen);
        InventoryPlayer inv = mc.thePlayer.inventory;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBindTexture((int)3553, (int)mc.renderEngine.getTexture("/assets/minecraft/textures/gui/gui.png"));
        gui.drawTexturedModalRect(x + 5, y, 0, 0, 182, 22);
        int selectedHotbar = (inv.hotbarOffset + 27) % 36 / 9;
        gui.drawTexturedModalRect(x, y, 24, 22, 6, 22);
        gui.drawTexturedModalRect(x, y + 1 + selectedHotbar * 5, 30, 23 + selectedHotbar * 5, 6, 5);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)32826);
        Lighting.enableInventoryLight();
        int lastHotbarStart = (mc.thePlayer.inventory.hotbarOffset + 27) % 36;
        int nextHotbarStart = (mc.thePlayer.inventory.hotbarOffset + 9) % 36;
        if (mc.hotbarSwapAnimationProgress != 0.0f) {
            Scissor.enable(x + 8, y + 3, 176, 16);
            if (mc.hotbarSwapAnimationProgress > 0.0f) {
                mc.hotbarSwapAnimationProgress -= partialTick * mc.hotbarSwapAnimationProgress * 2.0f / 16.0f;
                for (itemIndex = 0; itemIndex < 9; ++itemIndex) {
                    itemX = x + 8 + itemIndex * 20;
                    itemY = y + 3 - 22 + (int)(22.0f * mc.hotbarSwapAnimationProgress);
                    this.renderInventorySlot(mc, itemIndex + lastHotbarStart, itemX, itemY, partialTick);
                }
                if (mc.hotbarSwapAnimationProgress < 0.05f) {
                    mc.hotbarSwapAnimationProgress = 0.0f;
                }
            } else {
                mc.hotbarSwapAnimationProgress += partialTick * -mc.hotbarSwapAnimationProgress * 2.0f / 16.0f;
                for (itemIndex = 0; itemIndex < 9; ++itemIndex) {
                    itemX = x + 8 + itemIndex * 20;
                    itemY = y + 3 + 22 + (int)(22.0f * mc.hotbarSwapAnimationProgress);
                    this.renderInventorySlot(mc, itemIndex + nextHotbarStart, itemX, itemY, partialTick);
                }
                if (mc.hotbarSwapAnimationProgress > -0.05f) {
                    mc.hotbarSwapAnimationProgress = 0.0f;
                }
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (itemIndex = 0; itemIndex < 9; ++itemIndex) {
            itemX = x + 8 + itemIndex * 20;
            itemY = y + 3 + (int)(22.0f * mc.hotbarSwapAnimationProgress);
            this.renderInventorySlot(mc, itemIndex + mc.thePlayer.inventory.hotbarOffset, itemX, itemY, partialTick);
        }
        Scissor.disable();
        Lighting.disable();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBindTexture((int)3553, (int)mc.renderEngine.getTexture("/assets/minecraft/textures/gui/gui.png"));
        gui.drawTexturedModalRect(x + 4 + inv.currentItem % 9 * 20, y - 1, 0, 22, 24, 24);
        gui.guiHeldItemTooltip.updateAndRender(mc, x + 93, y - 20);
    }

    @Override
    public void renderPreview(Minecraft mc, Gui gui, Layout layout, int xSizeScreen, int ySizeScreen) {
        int x = layout.getComponentX(mc, this, xSizeScreen);
        int y = layout.getComponentY(mc, this, ySizeScreen);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBindTexture((int)3553, (int)mc.renderEngine.getTexture("/assets/minecraft/textures/gui/gui.png"));
        gui.drawTexturedModalRect(x + 5, y, 0, 0, 182, 22);
        gui.drawTexturedModalRect(x, y, 24, 22, 6, 22);
        gui.drawTexturedModalRect(x, y + 16, 30, 23, 6, 5);
        gui.drawTexturedModalRect(x + 4, y - 1, 0, 22, 24, 24);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)32826);
        Lighting.enableInventoryLight();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int itemIndex = 0; itemIndex < 9; ++itemIndex) {
            int itemX = x + 8 + itemIndex * 20;
            int itemY = y + 3;
            this.renderItem(mc, PREVIEW_ITEMS[itemIndex], itemX, itemY);
        }
        Lighting.disable();
    }

    private void renderInventorySlot(Minecraft mc, int itemIndex, int x, int y, float partialTick) {
        ItemStack itemstack = mc.thePlayer.inventory.mainInventory[itemIndex];
        if (itemstack == null) {
            return;
        }
        ItemModel itemModel = (ItemModel)ItemModelDispatcher.getInstance().getDispatch(itemstack.getItem());
        float animProgress = (float)itemstack.animationsToGo - partialTick;
        if (animProgress > 0.0f) {
            GL11.glPushMatrix();
            float f2 = 1.0f + animProgress / 5.0f;
            GL11.glTranslatef((float)(x + 8), (float)(y + 12), (float)0.0f);
            GL11.glScalef((float)(1.0f / f2), (float)((f2 + 1.0f) / 2.0f), (float)1.0f);
            GL11.glTranslatef((float)(-(x + 8)), (float)(-(y + 12)), (float)0.0f);
        }
        itemModel.renderItemIntoGui(Tessellator.instance, mc.fontRenderer, mc.renderEngine, itemstack, x, y, 1.0f);
        if (animProgress > 0.0f) {
            GL11.glPopMatrix();
        }
        itemModel.renderItemOverlayIntoGUI(Tessellator.instance, mc.fontRenderer, mc.renderEngine, itemstack, x, y, 1.0f);
    }

    private void renderItem(Minecraft mc, ItemStack itemStack, int x, int y) {
        ItemModel itemModel = (ItemModel)ItemModelDispatcher.getInstance().getDispatch(itemStack.getItem());
        itemModel.renderItemIntoGui(Tessellator.instance, mc.fontRenderer, mc.renderEngine, itemStack, x, y, 1.0f);
        itemModel.renderItemOverlayIntoGUI(Tessellator.instance, mc.fontRenderer, mc.renderEngine, itemStack, x, y, 1.0f);
    }
}

