/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.hud.ComponentAnchor;
import net.minecraft.client.gui.hud.HudComponent;
import net.minecraft.client.gui.hud.Layout;

public class AbsoluteLayout
extends Layout {
    private float xPosition;
    private float yPosition;
    private ComponentAnchor anchor;

    public AbsoluteLayout(float xPosition, float yPosition, ComponentAnchor anchor) {
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.anchor = anchor;
    }

    public float getXPosition() {
        return this.xPosition;
    }

    public float getYPosition() {
        return this.yPosition;
    }

    public ComponentAnchor getAnchor() {
        return this.anchor;
    }

    public void setXPosition(float xPosition) {
        this.xPosition = xPosition;
    }

    public void setYPosition(float yPosition) {
        this.yPosition = yPosition;
    }

    public void setAnchor(ComponentAnchor anchor) {
        this.anchor = anchor;
    }

    @Override
    public int getComponentX(Minecraft mc, HudComponent component, int xSizeScreen) {
        int sp = (int)(((Float)mc.gameSettings.screenPadding.value).floatValue() * (float)mc.resolution.scaledHeight / 8.0f);
        return (int)(this.xPosition * (float)xSizeScreen) - component.getAnchorX(this.anchor) + sp;
    }

    @Override
    public int getComponentY(Minecraft mc, HudComponent component, int ySizeScreen) {
        int sp = (int)(((Float)mc.gameSettings.screenPadding.value).floatValue() * (float)mc.resolution.scaledHeight / 8.0f);
        return (int)(this.yPosition * (float)ySizeScreen) - component.getAnchorY(this.anchor) + sp;
    }

    @Override
    public Layout copy() {
        return new AbsoluteLayout(this.xPosition, this.yPosition, this.anchor);
    }

    @Override
    public String toSettingsString() {
        return this.xPosition + "," + this.yPosition + "," + this.anchor.name();
    }

    @Override
    public void fromSettingsString(String settings) {
        String[] parts = settings.split(",");
        this.xPosition = Float.parseFloat(parts[0]);
        this.yPosition = Float.parseFloat(parts[1]);
        this.anchor = ComponentAnchor.valueOf(parts[2]);
    }
}

