/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.player;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.GetSkinUrlThread;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class EntityOtherPlayerMP
extends EntityPlayer {
    private int lerpTicks;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    float field_20924_a = 0.0f;

    public EntityOtherPlayerMP(World world, String s) {
        super(world);
        this.username = s;
        this.heightOffset = 0.0f;
        this.footSize = 0.0f;
        this.noPhysics = true;
        this.field_22062_y = 0.25f;
        this.viewScale = 10.0;
        new GetSkinUrlThread(this);
    }

    @Override
    protected void resetHeight() {
        this.heightOffset = 0.0f;
    }

    @Override
    public boolean hurt(Entity attacker, int i, DamageType type) {
        return true;
    }

    @Override
    public void lerpTo(double x, double y, double z, float yRot, float xRot, int ticks) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yRot;
        this.lerpXRot = xRot;
        this.lerpTicks = ticks;
    }

    @Override
    public void tick() {
        this.field_22062_y = 0.0f;
        super.tick();
        this.prevLimbYaw = this.limbYaw;
        this.xd = this.x - this.xo;
        this.yd = this.y - this.yo;
        this.zd = this.z - this.zo;
        float f = MathHelper.sqrt_double(this.xd * this.xd + this.zd * this.zd) * 4.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.limbYaw += (f - this.limbYaw) * 0.4f;
        this.limbSwing += this.limbYaw;
    }

    @Override
    public float getShadowHeightOffs() {
        return 0.0f;
    }

    @Override
    public void onDeath(Entity entityKilledBy) {
    }

    @Override
    public void onLivingUpdate() {
        super.updatePlayerActionState();
        if (this.lerpTicks > 0) {
            double d = this.x + (this.lerpX - this.x) / (double)this.lerpTicks;
            double d1 = this.y + (this.lerpY - this.y) / (double)this.lerpTicks;
            double d2 = this.z + (this.lerpZ - this.z) / (double)this.lerpTicks;
            double d3 = MathHelper.normalizeRotation(this.lerpYRot - (double)this.yRot);
            this.yRot = (float)((double)this.yRot + d3 / (double)this.lerpTicks);
            this.xRot = (float)((double)this.xRot + (this.lerpXRot - (double)this.xRot) / (double)this.lerpTicks);
            --this.lerpTicks;
            this.setPos(d, d1, d2);
            this.setRot(this.yRot, this.xRot);
        }
        this.cameraVelocityOld = this.cameraVelocity;
        float horizontalSpeed = MathHelper.sqrt_double(this.xd * this.xd + this.zd * this.zd);
        float f1 = (float)Math.atan(-this.yd * 0.2) * 15.0f;
        if (horizontalSpeed > 0.1f) {
            horizontalSpeed = 0.1f;
        }
        if (!this.onGround || this.getHealth() <= 0) {
            horizontalSpeed = 0.0f;
        }
        if (this.onGround || this.getHealth() <= 0) {
            f1 = 0.0f;
        }
        this.cameraVelocity += (horizontalSpeed - this.cameraVelocity) * 0.4f;
        this.cameraPitch += (f1 - this.cameraPitch) * 0.8f;
    }

    @Override
    public void setEquippedSlot(int i, int j, int k, CompoundTag tag) {
        ItemStack itemstack = null;
        if (j >= 0) {
            itemstack = new ItemStack(j, 1, k, tag);
        }
        if (i == 0) {
            this.inventory.mainInventory[this.inventory.currentItem] = itemstack;
        } else {
            this.inventory.armorInventory[i - 1] = itemstack;
        }
    }

    @Override
    public void func_6420_o() {
    }

    @Override
    public void sendMessage(String message) {
    }

    @Override
    public void sendStatusMessage(String message) {
    }
}

