/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Graphics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.window.GameWindowApplet;
import net.minecraft.core.player.Session;

public class MinecraftApplet
extends Applet {
    private Canvas minecraftCanvas = new MinecraftCanvas();
    private Minecraft mc;
    private Thread minecraftThread;

    @Override
    public void init() {
        String username = this.getParameter("username");
        String sessionid = this.getParameter("sessionid");
        if (username == null) {
            username = "Player";
        }
        if (sessionid == null) {
            sessionid = "-";
        }
        GameWindowApplet window = new GameWindowApplet(this);
        this.mc = new Minecraft(window);
        this.mc.session = new Session(username, sessionid);
        this.setLayout(new BorderLayout());
        this.add((Component)this.minecraftCanvas, "Center");
        this.minecraftCanvas.setFocusable(true);
        this.validate();
    }

    public Canvas getCanvas() {
        return this.minecraftCanvas;
    }

    public void startMainThread() {
        System.out.println("Start Main Thread!");
        if (this.minecraftThread != null) {
            return;
        }
        this.minecraftThread = new Thread((Runnable)this.mc, "Minecraft main thread");
        this.minecraftThread.start();
    }

    class MinecraftCanvas
    extends Canvas {
        MinecraftCanvas() {
        }

        @Override
        public synchronized void addNotify() {
            super.addNotify();
            MinecraftApplet.this.startMainThread();
        }

        @Override
        public synchronized void removeNotify() {
            super.removeNotify();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
        }
    }
}

